/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.lib;

import com.google.common.collect.Maps;
import java.util.IdentityHashMap;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.Level;
import weissmoon.core.utils.LogHelper;

public class OreColourList {
    private static final IdentityHashMap<String, Integer> oreColours = Maps.newIdentityHashMap();

    public static boolean addOreList(@Nonnull String oreName, @Nonnull int oreColour) {
        return OreColourList.addOreList(oreName, oreColour, false);
    }

    public static boolean addOreList(@Nonnull String oreName, @Nonnull int oreColour, boolean override) {
        if (oreColours.containsKey(oreName)) {
            if (override) {
                LogHelper.log((String)"welectromagic", (Level)Level.WARN, (Object)("Ore colour for " + oreName.toLowerCase() + " is being overridden by \"" + Loader.instance().activeModContainer().getModId() + "\""));
                LogHelper.log((String)"welectromagic", (Level)Level.WARN, (Object)("new value for " + oreName.toLowerCase() + " is " + oreColour));
            } else {
                return false;
            }
        }
        oreColours.put(oreName.toLowerCase(), oreColour);
        return true;
    }

    public static int getColour(String name) {
        if (oreColours.containsKey(name.toLowerCase())) {
            return oreColours.get(name.toLowerCase());
        }
        return 0xC0C0C0;
    }

    public static String[] getNames() {
        return oreColours.keySet().toArray(new String[0]);
    }

    static {
        OreColourList.addOreList("IRON", 14200723);
        OreColourList.addOreList("LAPIS", 1328572);
        OreColourList.addOreList("GOLD", 16576075);
        OreColourList.addOreList("DIAMOND", 6155509);
        OreColourList.addOreList("EMERALD", 1564002);
        OreColourList.addOreList("REDSTONE", 0xFF0000);
        OreColourList.addOreList("COAL", 0x101010);
        OreColourList.addOreList("silver", 10866917);
        OreColourList.addOreList("TIN", 0xEFEFFB);
        OreColourList.addOreList("COPPER", 16620629);
        OreColourList.addOreList("AMBER", 16626469);
        OreColourList.addOreList("CINNABAR", 10159368);
        OreColourList.addOreList("QUARTZ", 0xE5DED5);
        OreColourList.addOreList("Uranium", 6336528);
        OreColourList.addOreList("Ruby", 16725307);
        OreColourList.addOreList("Sapphire", 3027967);
        OreColourList.addOreList("GreenSapphire", 3991100);
    }
}

