/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.common.lib.utils.Utils;
import weissmoon.electromagictools.lib.OreColourList;

public class OverrideScanPacket
implements IMessage,
IMessageHandler<OverrideScanPacket, IMessage> {
    private BlockPos pos;
    private int size;

    public OverrideScanPacket() {
    }

    public OverrideScanPacket(BlockPos negaposi, int size) {
        this.pos = negaposi;
        this.size = size;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.size = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.size);
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(OverrideScanPacket message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> this.scann(message.pos, message.size));
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void scann(BlockPos posi, int sizeIn) {
        World world = Minecraft.func_71410_x().field_71439_g.field_70170_p;
        int range = 4 + sizeIn * 4;
        ArrayList<BlockPos> ores = new ArrayList<BlockPos>();
        for (int xx = -range; xx <= range; ++xx) {
            for (int yy = -range; yy <= range; ++yy) {
                for (int zz = -range; zz <= range; ++zz) {
                    BlockPos curPos = posi.func_177982_a(xx, yy, zz);
                    if (!Utils.isOreBlock((World)world, (BlockPos)curPos)) continue;
                    ores.add(curPos);
                }
            }
        }
        ArrayList<Object> group = new ArrayList<BlockPos>();
        while (!ores.isEmpty()) {
            BlockPos origin = (BlockPos)ores.get(0);
            group.add(origin);
            ores.remove(0);
            this.cullGroup(world, origin, group, ores);
            if (group.isEmpty()) continue;
            this.generateParticle(group, origin, posi);
            group = new ArrayList();
        }
    }

    private void cullGroup(World world, BlockPos origin, ArrayList<BlockPos> group, ArrayList<BlockPos> ores) {
        IBlockState originState = world.func_180495_p(origin);
        if (ores.isEmpty()) {
            return;
        }
        for (int xx = -1; xx <= 1; ++xx) {
            for (int yy = -1; yy <= 1; ++yy) {
                for (int zz = -1; zz <= 1; ++zz) {
                    BlockPos curPosi = origin.func_177982_a(xx, yy, zz);
                    IBlockState curState = world.func_180495_p(curPosi);
                    if (!curState.equals(originState) || !ores.contains(curPosi)) continue;
                    group.add(curPosi);
                    ores.remove(curPosi);
                    this.cullGroup(world, curPosi, group, ores);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void generateParticle(ArrayList<BlockPos> group, BlockPos origin, BlockPos ping) {
        double maxZ;
        double maxY;
        double maxX;
        World world = Minecraft.func_71410_x().field_71439_g.field_70170_p;
        double minX = maxX = (double)origin.func_177958_n();
        double minY = maxY = (double)origin.func_177956_o();
        double minZ = maxZ = (double)origin.func_177952_p();
        for (BlockPos pod : group) {
            if ((double)pod.func_177958_n() < minX) {
                minX = pod.func_177958_n();
            } else if ((double)pod.func_177958_n() > maxX) {
                maxX = pod.func_177958_n();
            }
            if ((double)pod.func_177956_o() < minY) {
                minY = pod.func_177956_o();
            } else if ((double)pod.func_177956_o() > maxY) {
                maxY = pod.func_177956_o();
            }
            if ((double)pod.func_177952_p() < minZ) {
                minZ = pod.func_177952_p();
                continue;
            }
            if (!((double)pod.func_177952_p() > maxZ)) continue;
            maxZ = pod.func_177952_p();
        }
        double x = (maxX + minX) / 2.0 + 0.5;
        double y = (maxY + minY) / 2.0 + 0.5;
        double z = (maxZ + minZ) / 2.0 + 0.5;
        double distance = ping.func_185332_f((int)x, (int)y, (int)z);
        FXGeneric particle = new FXGeneric(world, x, y, z, 0.0, 0.0, 0.0);
        particle.func_187114_a(44);
        int color = this.getColour(origin);
        float red = color >> 16 & 0xFF;
        float green = color >> 8 & 0xFF;
        float blue = color & 0xFF;
        particle.func_70538_b(red / 255.0f, green / 255.0f, blue / 255.0f);
        float alpha = (red / 255.0f + green / 255.0f + blue / 255.0f) / 3.0f;
        particle.setAlphaF(new float[]{0.0f, 1.0f, 0.8f, 0.0f});
        particle.setParticles(240, 15, 1);
        particle.setGridSize(16);
        particle.setLoop(true);
        particle.setScale(new float[]{9.0f});
        particle.setLayer(alpha < 0.25f ? 3 : 2);
        particle.setRotationSpeed(0.0f);
        ParticleEngine.addEffectWithDelay((World)world, (Particle)particle, (int)((int)(distance * 2.0)));
    }

    private int getColour(BlockPos pos) {
        World world = Minecraft.func_71410_x().field_71439_g.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        int colour = 0xC0C0C0;
        if (block != Blocks.field_150357_h && block != Blocks.field_150350_a) {
            ItemStack stack = new ItemStack(block, 1, block.func_176201_c(state));
            if (block == Blocks.field_150439_ay) {
                stack = new ItemStack(Blocks.field_150450_ax);
            }
            if (stack.func_190926_b()) {
                return colour;
            }
            int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
            if (oreIDs.length > 0) {
                for (int id : oreIDs) {
                    for (String name : OreColourList.getNames()) {
                        if (OreDictionary.getOreName((int)id).toLowerCase().contains(name)) {
                            colour = OreColourList.getColour(name);
                        }
                        if (colour == 0xC0C0C0) continue;
                        return colour;
                    }
                }
            }
        }
        return colour;
    }
}

