/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.api.world;

import com.google.common.collect.Lists;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.chunk.ChunkPrimer;

public abstract class IFluidStatePrimer {
    @Nonnull
    protected final List<FluidState> keys = Lists.newArrayList((Object[])new FluidState[]{FluidState.EMPTY});
    protected final char[] fluidData = new char[65536];

    @Nonnull
    public FluidState getFluidState(int x, int y, int z) {
        return this.keys.get(this.fluidData[ChunkPrimer.func_186137_b((int)x, (int)y, (int)z)]);
    }

    public void setFluidState(int x, int y, int z, @Nonnull FluidState fluidState) {
        if (fluidState.isEmpty()) {
            this.fluidData[ChunkPrimer.func_186137_b((int)x, (int)y, (int)z)] = '\u0000';
        } else {
            int indexedState = this.keys.indexOf((Object)fluidState);
            if (indexedState == -1) {
                indexedState = this.keys.size();
                this.keys.add(fluidState);
            }
            this.fluidData[ChunkPrimer.func_186137_b((int)x, (int)y, (int)z)] = (char)indexedState;
        }
    }

    @Nonnull
    public static IFluidStatePrimer of(@Nonnull ChunkPrimer primer) {
        return (IFluidStatePrimer)primer;
    }
}

