/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.forge;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.api.world.IChunkProvider;
import git.jbredwards.fluidlogged_api.mod.common.fluid.handler.FluidExtendedStateHandler;
import git.jbredwards.fluidlogged_api.mod.common.fluid.handler.FluidFlowHandler;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.impl.SpecializedFluidNeighborInfo;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.Fluid;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;

public final class PluginBlockFluidBase
implements IASMPlugin {
    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if (this.checkMethod(method, "<init>", "(Lnet/minecraftforge/fluids/Fluid;Lnet/minecraft/block/material/Material;Lnet/minecraft/block/material/MapColor;)V")) {
            return 1;
        }
        if (this.checkMethod(method, "<clinit>", "()V")) {
            return 2;
        }
        if (method.name.equals("getFlowDirection") || method.name.equals("getDensity") || method.name.equals("getTemperature")) {
            return 4;
        }
        if (method.name.equals("getFluid")) {
            return 5;
        }
        return method.name.equals("getFogColor") ? 3 : 0;
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 1 && this.checkField(insn, "defaultDisplacements", "Ljava/util/Map;")) {
            instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("defaultDisplacements", "(Ljava/util/Map;)Ljava/util/Map;"));
            return true;
        }
        if (index == 2 && insn.getNext().getOpcode() == 18) {
            while (insn.getPrevious().getOpcode() != 179) {
                instructions.remove(insn.getPrevious());
            }
            return true;
        }
        if (index == 3 && this.checkMethod(insn, "isWithinFluid")) {
            instructions.insert(insn, (AbstractInsnNode)new InsnNode(4));
            this.removeFrom(instructions, insn, -6);
            return true;
        }
        if (index == 4 && this.checkMethod(insn, obfuscated ? "func_180495_p" : "getBlockState")) {
            instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("git/jbredwards/fluidlogged_api/api/util/FluidloggedUtils", "getFluidOrReal", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;"));
            instructions.remove(insn);
            return true;
        }
        if (index == 5 && this.checkMethod(insn, "getFluid", "(Ljava/lang/String;)Lnet/minecraftforge/fluids/Fluid;")) {
            instructions.insert(insn, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraftforge/fluids/BlockFluidBase", "definedFluid", "Lnet/minecraftforge/fluids/Fluid;"));
            instructions.remove(insn.getPrevious());
            instructions.remove(insn);
            return true;
        }
        return false;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals(obfuscated ? "func_176225_a" : "shouldSideBeRendered"), "shouldFluidSideBeRendered", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;I)Z", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 4);
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidBase", "densityDir", "I");
        });
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals("getExtendedState"), "getFluidExtendedState", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Lnet/minecraft/block/state/IBlockState;", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 1);
        });
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals("getFlowVector"), "getFluidFlowVector", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/util/math/Vec3d;", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
        });
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals("hasVerticalFlow"), "hasVerticalFlow", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraftforge/fluids/Fluid;I)Z", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 0);
            generator.visitMethodInsn(185, "net/minecraftforge/fluids/IFluidBlock", "getFluid", "()Lnet/minecraftforge/fluids/Fluid;", true);
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidBase", "densityDir", "I");
        });
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals("getStateAtViewpoint"), null, null, (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 4);
            generator.visitMethodInsn(184, "git/jbredwards/fluidlogged_api/mod/common/fluid/handler/FluidCollisionHandler", "getStateAtViewpoint", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/Vec3d;)Lnet/minecraft/block/state/IBlockState;", false);
        });
        this.addMethod(classNode, "isEntityInsideMaterial", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;DLnet/minecraft/block/material/Material;Z)Ljava/lang/Boolean;", null, null, generator -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 4);
            generator.visitVarInsn(24, 5);
            generator.visitVarInsn(25, 7);
            generator.visitVarInsn(21, 8);
            generator.visitMethodInsn(184, "git/jbredwards/fluidlogged_api/mod/common/fluid/handler/FluidCollisionHandler", "isEntityInsideMaterial", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;DLnet/minecraft/block/material/Material;Z)Ljava/lang/Boolean;", false);
        });
        this.addMethod(classNode, "isAABBInsideMaterial", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;Lnet/minecraft/block/material/Material;)Ljava/lang/Boolean;", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraft/block/Block", obfuscated ? "field_149764_J" : "material", "Lnet/minecraft/block/material/Material;");
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 4);
            generator.visitMethodInsn(184, "git/jbredwards/fluidlogged_api/mod/common/fluid/handler/FluidCollisionHandler", "isAABBInsideMaterial", "(Lnet/minecraft/block/material/Material;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;Lnet/minecraft/block/material/Material;)Ljava/lang/Boolean;", false);
        });
        this.addMethod(classNode, "isAABBInsideLiquid", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;)Ljava/lang/Boolean;", null, null, generator -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitMethodInsn(184, "git/jbredwards/fluidlogged_api/mod/common/fluid/handler/FluidCollisionHandler", "isAABBInsideLiquid", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;)Ljava/lang/Boolean;", false);
        });
        classNode.interfaces.add("git/jbredwards/fluidlogged_api/mod/asm/plugins/forge/PluginBlockFluidBase$Accessor");
        this.addMethod(classNode, "getDensityDir_Public", "()I", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidBase", "densityDir", "I");
        });
        this.addMethod(classNode, "getQuantaPerBlockFloat_Public", "()F", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidBase", "quantaPerBlockFloat", "F");
        });
        this.addMethod(classNode, "getQuantaPerBlock_Public", "()I", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidBase", "quantaPerBlock", "I");
        });
        this.addMethod(classNode, "getQuantaFraction_Public", "()F", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidBase", "quantaFraction", "F");
        });
        this.addMethod(classNode, "getDisplacements_Public", "()Ljava/util/Map;", "()Ljava/util/Map<Lnet/minecraft/block/Block;Ljava/lang/Boolean;>;", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidBase", "displacements", "Ljava/util/Map;");
        });
        return true;
    }

    @Override
    public boolean recalcFrames(boolean obfuscated) {
        return true;
    }

    public static interface Accessor {
        public int getDensityDir_Public();

        public int getQuantaPerBlock_Public();

        public float getQuantaFraction_Public();

        public float getQuantaPerBlockFloat_Public();

        @Nonnull
        public Map<Block, Boolean> getDisplacements_Public();
    }

    public static final class Hooks {
        @Nonnull
        public static Map<Block, Boolean> defaultDisplacements(@Nonnull Map<Block, Boolean> map) {
            HashMap<Block, Boolean> ret = new HashMap<Block, Boolean>();
            ret.put((Block)Blocks.field_180413_ao, false);
            ret.put((Block)Blocks.field_180414_ap, false);
            ret.put((Block)Blocks.field_180412_aq, false);
            ret.put((Block)Blocks.field_180411_ar, false);
            ret.put((Block)Blocks.field_180410_as, false);
            ret.put((Block)Blocks.field_180409_at, false);
            ret.put(Blocks.field_150415_aT, false);
            ret.put(Blocks.field_180400_cw, false);
            ret.put(Blocks.field_180407_aO, false);
            ret.put(Blocks.field_180408_aP, false);
            ret.put(Blocks.field_180404_aQ, false);
            ret.put(Blocks.field_180403_aR, false);
            ret.put(Blocks.field_180406_aS, false);
            ret.put(Blocks.field_180405_aT, false);
            ret.put(Blocks.field_150386_bk, false);
            ret.put(Blocks.field_180390_bo, false);
            ret.put(Blocks.field_180391_bp, false);
            ret.put(Blocks.field_180392_bq, false);
            ret.put(Blocks.field_180386_br, false);
            ret.put(Blocks.field_180385_bs, false);
            ret.put(Blocks.field_180387_bt, false);
            ret.put(Blocks.field_150452_aw, false);
            ret.put(Blocks.field_150456_au, false);
            ret.put(Blocks.field_150445_bS, false);
            ret.put(Blocks.field_150443_bT, false);
            ret.put(Blocks.field_150468_ap, false);
            ret.put(Blocks.field_150411_aY, false);
            ret.put(Blocks.field_150410_aZ, false);
            ret.put((Block)Blocks.field_150397_co, false);
            ret.put((Block)Blocks.field_150427_aO, false);
            ret.put(Blocks.field_150384_bq, false);
            ret.put(Blocks.field_150463_bK, false);
            ret.put(Blocks.field_180401_cv, false);
            ret.put(Blocks.field_180393_cK, false);
            ret.put(Blocks.field_180394_cL, false);
            ret.put(Blocks.field_150414_aQ, false);
            ret.put((Block)Blocks.field_150454_av, false);
            ret.put(Blocks.field_150472_an, false);
            ret.put(Blocks.field_150444_as, false);
            ret.put((Block)Blocks.field_150436_aH, false);
            ret.putAll(map);
            return ret;
        }

        @Nonnull
        public static IBlockState getFluidExtendedState(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
            return FluidExtendedStateHandler.getExtendedState(state, new SpecializedFluidNeighborInfo.Forge(world, pos, FluidState.of(state), 1), FluidFlowHandler::getFlowAngle);
        }

        @Nonnull
        public static Vec3d getFluidFlowVector(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
            return FluidFlowHandler.getFlowVec(new SpecializedFluidNeighborInfo.Forge(world, pos, FluidloggedUtils.getFluidState(world, pos), 1));
        }

        public static boolean hasVerticalFlow(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull Fluid fluid, int densityDir) {
            Chunk chunk;
            EnumFacing facing;
            EnumFacing enumFacing = facing = densityDir < 0 ? EnumFacing.UP : EnumFacing.DOWN;
            if (!FluidloggedUtils.canFluidFlow(world, pos, world.func_180495_p(pos), facing)) {
                return false;
            }
            BlockPos offset = pos.func_177979_c(densityDir);
            if (world instanceof IChunkProvider && (chunk = ((IChunkProvider)world).getChunk((Vec3i)pos)) != null) {
                IBlockState state = chunk.func_177435_g(offset);
                return FluidloggedUtils.canFluidFlow(world, offset, state, facing.func_176734_d()) && FluidloggedUtils.isCompatibleFluid(FluidloggedUtils.getFluidState(chunk, offset, state).getFluid(), fluid);
            }
            IBlockState state = world.func_180495_p(offset);
            return FluidloggedUtils.canFluidFlow(world, offset, state, facing.func_176734_d()) && FluidloggedUtils.isCompatibleFluid(FluidloggedUtils.getFluidState(world, offset, state).getFluid(), fluid);
        }

        public static boolean shouldFluidSideBeRendered(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, int densityDir) {
            BlockPos offset;
            IBlockState neighbor;
            if (!FluidloggedUtils.canFluidFlow(world, pos, world.func_180495_p(pos), side)) {
                return true;
            }
            Fluid fluid = FluidloggedUtils.getFluidFromState(state);
            if (FluidloggedUtils.isCompatibleFluid(fluid, FluidloggedUtils.getFluidFromState(neighbor = world.func_180495_p(offset = pos.func_177972_a(side))))) {
                return false;
            }
            if (side != (densityDir > 0 ? EnumFacing.DOWN : EnumFacing.UP) && neighbor.doesSideBlockRendering(world, offset, side.func_176734_d())) {
                return false;
            }
            return !FluidloggedUtils.canFluidFlow(world, offset, neighbor, side.func_176734_d()) || !FluidloggedUtils.isCompatibleFluid(FluidloggedUtils.getFluidState(world, offset, neighbor).getFluid(), fluid);
        }
    }
}

