/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.forge;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginFluidBucketWrapper
implements IASMPlugin {
    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        return "getFluid".equals(method.name) ? 1 : (this.checkMethod(method, "setFluid", "(Lnet/minecraftforge/fluids/FluidStack;)V") ? 2 : 0);
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 1 && insn.getOpcode() == 1) {
            instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("getFluid", "(Lnet/minecraft/item/Item;Lnet/minecraftforge/fluids/FluidStack;)Lnet/minecraftforge/fluids/FluidStack;"));
            return true;
        }
        if (index == 2 && this.checkField(insn, "container")) {
            instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.insertBefore(insn, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraftforge/fluids/capability/wrappers/FluidBucketWrapper", "container", "Lnet/minecraft/item/ItemStack;"));
            instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("getContainer", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;"));
            return true;
        }
        return false;
    }

    public static final class Hooks {
        @Nonnull
        public static ItemStack getContainer(@Nonnull ItemStack fallback, @Nonnull ItemStack container) {
            return container.func_77973_b().hasContainerItem(container) ? container.func_77973_b().getContainerItem(container).func_77946_l() : fallback;
        }

        @Nullable
        public static FluidStack getFluid(@Nonnull Item bucket, @Nullable FluidStack fallback) {
            if (!(bucket instanceof ItemBucket)) {
                return fallback;
            }
            Fluid containedFluid = FluidloggedUtils.getFluidFromBlock(((ItemBucket)bucket).field_77876_a);
            return containedFluid == null ? fallback : new FluidStack(containedFluid, 1000);
        }
    }
}

