/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.modded.biomesoplenty;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfig;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginBiomesOPlenty
implements IASMPlugin {
    final boolean syncQuantaFloat;

    public PluginBiomesOPlenty(boolean syncQuantaFloatIn) {
        this.syncQuantaFloat = syncQuantaFloatIn;
    }

    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if (this.syncQuantaFloat && method.name.equals("<init>")) {
            return 1;
        }
        return method.name.equals("checkForMixing") ? 2 : 0;
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 1 && insn.getOpcode() == 181) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraftforge/fluids/BlockFluidBase", "quantaPerBlock", "I"));
            list.add((AbstractInsnNode)new InsnNode(134));
            list.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraftforge/fluids/BlockFluidBase", "quantaPerBlockFloat", "F"));
            instructions.insert(insn, list);
            return true;
        }
        if (index == 2) {
            if (this.checkMethod(insn, obfuscated ? "func_76224_d" : "isLiquid")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("canBOPFluidFlow", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)Z"));
                this.removeFrom(instructions, insn, -3);
            } else if (this.checkMethod(insn.getNext(), obfuscated ? "func_177230_c" : "getBlock")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("getBOPFluidOrFalse", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Lnet/minecraft/block/state/IBlockState;"));
                instructions.insert(insn, (AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/block/Block", obfuscated ? "func_176223_P" : "getDefaultState", "()Lnet/minecraft/block/state/IBlockState;", false));
                instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.remove(insn);
                return true;
            }
        }
        return false;
    }

    public static final class Hooks {
        public static boolean canBOPFluidFlow(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing) {
            IBlockState here = world.func_180495_p(pos);
            return here.func_177230_c().func_176200_f((IBlockAccess)world, pos) && (!FluidloggedAPIConfig.fixBadFluidMixing || FluidloggedUtils.canFluidFlow((IBlockAccess)world, pos, here, facing) && FluidloggedUtils.canFluidFlow((IBlockAccess)world, pos.func_177972_a(facing), world.func_180495_p(pos.func_177972_a(facing)), facing.func_176734_d()));
        }

        @Nonnull
        public static IBlockState getBOPFluidOrFalse(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
            FluidState fluidState = FluidloggedUtils.getFluidState((IBlockAccess)world, pos);
            return fluidState.isEmpty() ? state : fluidState.getState();
        }
    }
}

