/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.modded.mekanism;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.item.PluginItemBucket;
import javax.annotation.Nonnull;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.item.ItemBlockMachine;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public final class PluginMekanismTank
implements IASMPlugin {
    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals(obfuscated ? "func_77659_a" : "onItemRightClick"), "onItemRightClick", "(Lmekanism/common/item/ItemBlockMachine;Lnet/minecraft/world/World;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/EnumHand;)Lnet/minecraft/util/ActionResult;", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
        });
        return true;
    }

    public static final class Hooks {
        @Nonnull
        public static ActionResult<ItemStack> onItemRightClick(@Nonnull ItemBlockMachine machine, @Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
            ItemStack held = player.func_184586_b(hand);
            switch (BlockStateMachine.MachineType.get((ItemStack)held)) {
                case PERSONAL_CHEST: {
                    if (world.field_72995_K) break;
                    if (machine.getOwnerUUID(held) == null) {
                        machine.setOwnerUUID(held, player.func_110124_au());
                    }
                    if (SecurityUtils.canAccess((EntityPlayer)player, (ItemStack)held)) {
                        MekanismUtils.openItemGui((EntityPlayer)player, (EnumHand)hand, (int)19);
                        break;
                    }
                    SecurityUtils.displayNoAccess((EntityPlayer)player);
                    break;
                }
                case FLUID_TANK: {
                    if (!machine.getBucketMode(held)) break;
                    if (SecurityUtils.canAccess((EntityPlayer)player, (ItemStack)held)) {
                        if (!player.func_70093_af()) {
                            return PluginItemBucket.Hooks.onRightClickBucket(world, player, hand, Blocks.field_150350_a);
                        }
                        FluidStack contained = machine.getFluid(held);
                        if (contained == null || contained.amount < 1000 || !contained.getFluid().canBePlacedInWorld()) {
                            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)held);
                        }
                        return PluginItemBucket.Hooks.onRightClickBucket(world, player, hand, contained.getFluid().getBlock());
                    }
                    SecurityUtils.displayNoAccess((EntityPlayer)player);
                }
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)held);
        }
    }
}

