/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.block;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.world.PluginWorld;
import javax.annotation.Nonnull;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.BlockStateContainer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;

public final class PluginBlockDoor
implements IASMPlugin {
    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if (method.name.equals(obfuscated ? "func_180639_a" : "onBlockActivated") || method.name.equals(obfuscated ? "func_176512_a" : "toggleDoor") || method.name.equals(obfuscated ? "func_189540_a" : "neighborChanged")) {
            return 1;
        }
        return method.name.equals(obfuscated ? "func_176208_a" : "onBlockHarvested") ? 2 : 0;
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 1 && this.checkMethod(insn, obfuscated ? "func_175704_b" : "markBlockRangeForRenderUpdate", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;)V")) {
            instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("notifyDoorFluids", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;)V"));
            instructions.remove(insn);
            return true;
        }
        if (index == 2) {
            if (this.checkField(insn, obfuscated ? "field_75098_d" : "isCreativeMode") && this.getNext(insn, 3) instanceof LineNumberNode) {
                instructions.insert(insn, (AbstractInsnNode)new InsnNode(3));
                this.removeFrom(instructions, insn, -2);
            } else if (this.checkMethod(insn, obfuscated ? "func_175698_g" : "setBlockToAir")) {
                boolean isLast = this.getNext(insn, 5).getOpcode() == 177;
                instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("setBlockToAirNoUpdate", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V"));
                this.removeFrom(instructions, insn, 1);
                return isLast;
            }
        }
        return false;
    }

    public static final class Hooks {
        public static void notifyDoorFluids(@Nonnull World world, @Nonnull BlockPos rangeMin, @Nonnull BlockPos rangeMax) {
            FluidloggedUtils.notifyFluids(world, rangeMin.func_177984_a(), null, true, EnumFacing.DOWN);
            world.func_175704_b(rangeMin, rangeMax);
        }

        public static void setBlockToAirNoUpdate(@Nonnull World world, @Nonnull BlockPos pos) {
            PluginWorld.Hooks.setBlockToAir(world, pos, BlockStateContainer.field_186020_a, 2);
            world.func_175695_a(pos, Blocks.field_150350_a, EnumFacing.DOWN);
            world.func_190522_c(pos, Blocks.field_150350_a);
        }
    }
}

