/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.world;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.world.IChunkProvider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public final class PluginChunkCache
implements IASMPlugin {
    @Override
    public boolean isMethodValid(@Nonnull MethodNode method, boolean obfuscated) {
        return method.name.equals(obfuscated ? "func_175629_a" : "getLightForExt");
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (this.checkMethod(insn, obfuscated ? "func_185916_f" : "useNeighborBrightness")) {
            instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("useNeighborBrightness", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Z"));
            this.removeFrom(instructions, insn, -1);
            return true;
        }
        return false;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        classNode.interfaces.add("git/jbredwards/fluidlogged_api/api/world/IWorldProvider");
        this.addMethod(classNode, "getWorld", "()Lnet/minecraft/world/World;", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraft/world/ChunkCache", obfuscated ? "field_72815_e" : "world", "Lnet/minecraft/world/World;");
        });
        classNode.interfaces.add("git/jbredwards/fluidlogged_api/api/world/IChunkProvider");
        this.addMethod(classNode, "getChunk", "(II)Lnet/minecraft/world/chunk/Chunk;", "getChunkFromChunkCache", "(II[[Lnet/minecraft/world/chunk/Chunk;II)Lnet/minecraft/world/chunk/Chunk;", generator -> {
            generator.visitVarInsn(21, 1);
            generator.visitVarInsn(21, 2);
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraft/world/ChunkCache", obfuscated ? "field_72817_c" : "chunkArray", "[[Lnet/minecraft/world/chunk/Chunk;");
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraft/world/ChunkCache", obfuscated ? "field_72818_a" : "chunkX", "I");
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraft/world/ChunkCache", obfuscated ? "field_72816_b" : "chunkZ", "I");
        });
        return true;
    }

    public static final class Hooks {
        @Nullable
        public static Chunk getChunkFromChunkCache(int chunkXIn, int chunkZIn, @Nonnull Chunk[][] chunkArray, int chunkX, int chunkZ) {
            int x = chunkXIn - chunkX;
            int z = chunkZIn - chunkZ;
            return x >= 0 && x < chunkArray.length && z >= 0 && z < chunkArray[x].length ? chunkArray[x][z] : null;
        }

        public static boolean useNeighborBrightness(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
            Chunk chunk = ((IChunkProvider)world).getChunk((Vec3i)pos);
            return chunk != null && Hooks.useNeighborBrightness(chunk.func_177435_g(pos), world, pos, chunk);
        }

        public static boolean useNeighborBrightness(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull Chunk chunk) {
            return state.func_185916_f() || FluidState.getFromProvider((ICapabilityProvider)chunk, pos).getState().func_185916_f();
        }
    }
}

