/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.config.handler;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfig;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.crafting.CraftingHelper;

public final class LegacyConfigHandler {
    @Nonnull
    private static final Path OLD_CONFIG_PATH = Paths.get("config", "fluidlogged_api.cfg");

    public static void convertOldFile() throws IOException {
        Path blacklist = Paths.get("config", "fluidlogged_api", "blacklist.cfg");
        Path fluidTags = Paths.get("config", "fluidlogged_api", "fluidTags.cfg");
        Path whitelist = Paths.get("config", "fluidlogged_api", "whitelist.cfg");
        if (!Files.exists(blacklist, new LinkOption[0])) {
            Files.write(blacklist, Collections.singleton("[\n\n]"), StandardOpenOption.CREATE);
        }
        if (!Files.exists(fluidTags, new LinkOption[0])) {
            Files.write(fluidTags, Collections.singleton("[\n\n]"), StandardOpenOption.CREATE);
        }
        if (!Files.exists(whitelist, new LinkOption[0])) {
            Files.write(whitelist, Collections.singleton("[\n\n]"), StandardOpenOption.CREATE);
        }
        if (Files.exists(OLD_CONFIG_PATH, new LinkOption[0])) {
            Throwable throwable;
            BufferedWriter writer;
            byte[] bytes = Files.readAllBytes(OLD_CONFIG_PATH);
            JsonObject json = new JsonParser().parse('{' + new String(bytes) + '}').getAsJsonObject();
            FluidloggedAPIConfig.bucketFluidlogging = FluidloggedAPIConfig.BucketFluidloggingMode.NO_SNEAK;
            FluidloggedAPIConfig.downloadModConfigs = FluidloggedAPIConfig.OnlineConfigMode.DISABLED;
            FluidloggedAPIConfig.fancyFluidEntityCollision = FluidloggedAPIConfig.FancyCollisionMode.NEVER;
            FluidloggedAPIConfig.lavalogVaporizeFlammable = FluidloggedAPIConfig.LavaVaporizingMode.NEVER;
            FluidloggedAPIConfig.ignoreLowFluidCollision = false;
            FluidloggedAPIConfig.fluidStateIsFireInsulator = false;
            FluidloggedAPIConfig.nonSourceFluidlogging = false;
            if (json.has("applyDefaults") && !JsonUtils.func_151216_b((JsonElement)json.get("applyDefaults"), (String)"applyDefaults")) {
                FluidloggedAPIConfig.allowDefaults = false;
            }
            if (json.has("fancyFluidEntityCollision") && JsonUtils.func_151216_b((JsonElement)json.get("fancyFluidEntityCollision"), (String)"fancyFluidEntityCollision")) {
                FluidloggedAPIConfig.fancyFluidEntityCollision = FluidloggedAPIConfig.FancyCollisionMode.ALWAYS;
            }
            if (json.has("lavalogVaporizeFlammable") && JsonUtils.func_151216_b((JsonElement)json.get("lavalogVaporizeFlammable"), (String)"lavalogVaporizeFlammable")) {
                FluidloggedAPIConfig.lavalogVaporizeFlammable = FluidloggedAPIConfig.LavaVaporizingMode.FLUIDLOGGABLE;
            }
            ConfigManager.sync((String)"fluidlogged_api", (Config.Type)Config.Type.INSTANCE);
            if (json.has("blacklist")) {
                writer = Files.newBufferedWriter(blacklist, new OpenOption[0]);
                throwable = null;
                try {
                    CraftingHelper.GSON.toJson(json.get("blacklist"), (Appendable)writer);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer != null) {
                        if (throwable != null) {
                            try {
                                ((Writer)writer).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((Writer)writer).close();
                        }
                    }
                }
            }
            if (json.has("fluidTags")) {
                writer = Files.newBufferedWriter(fluidTags, new OpenOption[0]);
                throwable = null;
                try {
                    CraftingHelper.GSON.toJson(json.get("fluidTags"), (Appendable)writer);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (writer != null) {
                        if (throwable != null) {
                            try {
                                ((Writer)writer).close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            ((Writer)writer).close();
                        }
                    }
                }
            }
            if (json.has("whitelist")) {
                writer = Files.newBufferedWriter(whitelist, new OpenOption[0]);
                throwable = null;
                try {
                    CraftingHelper.GSON.toJson(json.get("whitelist"), (Appendable)writer);
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (writer != null) {
                        if (throwable != null) {
                            try {
                                ((Writer)writer).close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            ((Writer)writer).close();
                        }
                    }
                }
            }
            Files.write(Paths.get("config", "fluidlogged_api.cfg_old"), bytes, new OpenOption[0]);
            Files.delete(OLD_CONFIG_PATH);
            Files.write(Paths.get("config", "fluidlogged_api.cfg_README.txt"), Arrays.asList("As of Fluidlogged API v3.0.0, the config is broken up into multiple files, and is stored in a new `./config/fluidlogged_api` folder.", "", "Any data in your old config should have been converted automatically. But just in case, a copy of your old config exists as `./config/fluidlogged_api.cfg_old`.", "WARNING: Do NOT change the suffix of the old config file back to `.cfg`! This will make fluidlogged api try to convert the file again, voiding any changes you may have made to the new config files since the previous conversion!", "", "Once you've made sure all of your old settings have been transferred correctly, feel free to delete this README file and `./config/fluidlogged_api.cfg_old`!"), new OpenOption[0]);
        }
    }
}

