/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.fluid.handler;

import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.api.world.IWorldProvider;
import git.jbredwards.fluidlogged_api.mod.asm.iface.IConfigFluidBox;
import git.jbredwards.fluidlogged_api.mod.asm.iface.IWaterHeight;
import git.jbredwards.fluidlogged_api.mod.asm.transformers.TransformerMethodRedirects;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfig;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.FluidCache;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.BlockStateContainer;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class FluidCollisionHandler {
    @Nonnull
    public static final ThreadLocal<IWaterHeight> cacheHeight = new ThreadLocal();

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public static IBlockState getStateAtViewpoint(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull Vec3d viewpoint) {
        Entity viewpointEntity = Objects.requireNonNull(Minecraft.func_71410_x().func_175606_aa());
        if (FluidCollisionHandler.isWithinFluid(world, pos, viewpoint.field_72450_a, viewpoint.field_72448_b, viewpoint.field_72449_c, state, viewpointEntity.func_174813_aQ(), viewpointEntity, false)) {
            return state;
        }
        IBlockState here = world.func_180495_p(pos);
        return here == state ? BlockStateContainer.field_186020_a : here.func_177230_c().getStateAtViewpoint(here, world, pos, viewpoint);
    }

    @Nullable
    public static Boolean isAABBInsideMaterial(@Nonnull Material material, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB bb, @Nonnull Material materialToTest) {
        return material != materialToTest ? null : FluidCollisionHandler.isAABBInsideLiquid(world, pos, bb.func_186664_h(0.001), null, TransformerMethodRedirects.Hooks.currentEntity, false);
    }

    @Nonnull
    public static Boolean isAABBInsideLiquid(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB bb) {
        return FluidCollisionHandler.isAABBInsideLiquid(worldIn, pos, bb.func_186664_h(0.001), null, TransformerMethodRedirects.Hooks.currentEntity, false);
    }

    @Nullable
    public static Boolean isEntityInsideMaterial(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entity, double yToTest, @Nonnull Material materialIn, boolean testingHead) {
        if (materialIn != state.func_185904_a() || !(state instanceof IExtendedBlockState)) {
            return null;
        }
        return testingHead ? Boolean.valueOf(FluidCollisionHandler.isWithinFluid(worldIn, pos, entity.field_70165_t, yToTest, entity.field_70161_v, state, entity.func_174813_aQ().func_186664_h(0.001), entity, true)) : FluidCollisionHandler.isAABBInsideLiquid(worldIn, pos, entity.func_174813_aQ().func_186664_h(0.001), state, entity, true);
    }

    @Nonnull
    static Boolean isAABBInsideLiquid(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB bb, @Nullable IBlockState stateIn, @Nullable Object entity, boolean checkCache) {
        if (bb.field_72340_a > (double)(pos.func_177958_n() + 1) || bb.field_72336_d < (double)pos.func_177958_n() || bb.field_72339_c > (double)(pos.func_177952_p() + 1) || bb.field_72334_f < (double)pos.func_177952_p()) {
            return Boolean.FALSE;
        }
        if (!FluidloggedAPIConfig.fancyFluidEntityCollision.test(bb, entity) || bb.field_72340_a < (double)pos.func_177958_n() && bb.field_72336_d > (double)(pos.func_177952_p() + 1) && bb.field_72339_c < (double)pos.func_177952_p() && bb.field_72334_f > (double)(pos.func_177952_p() + 1) || !IWorldProvider.getWorld(worldIn).func_175707_a(pos.func_177982_a(-1, -1, -1), pos.func_177982_a(1, 1, 1))) {
            IBlockAccess world = worldIn instanceof World ? new FluidCache(worldIn, (Vec3i)pos, 0, 1) : worldIn;
            return FluidCollisionHandler.isYWithinFluidEstimate(world, pos, bb.field_72338_b, bb.field_72337_e, stateIn != null ? stateIn : FluidloggedUtils.getFluidOrReal(world, pos), checkCache);
        }
        IBlockAccess access = worldIn instanceof World ? new FluidCache(worldIn, (Vec3i)pos, 1, 1) : worldIn;
        IBlockState state = stateIn != null ? stateIn : FluidloggedUtils.getFluidOrReal(access, pos);
        IBlockState extendedState = state.func_177230_c().getExtendedState(state, access, pos);
        return !(extendedState instanceof IExtendedBlockState) ? FluidCollisionHandler.isYWithinFluidEstimate(access, pos, bb.field_72338_b, bb.field_72337_e, state, checkCache) : FluidCollisionHandler.isPointWithinFluid(pos, bb.field_72340_a, bb.field_72338_b, bb.field_72337_e, bb.field_72339_c, (IExtendedBlockState)extendedState, checkCache) || FluidCollisionHandler.isPointWithinFluid(pos, bb.field_72340_a, bb.field_72338_b, bb.field_72337_e, bb.field_72334_f, (IExtendedBlockState)extendedState, checkCache) || FluidCollisionHandler.isPointWithinFluid(pos, bb.field_72336_d, bb.field_72338_b, bb.field_72337_e, bb.field_72339_c, (IExtendedBlockState)extendedState, checkCache) || FluidCollisionHandler.isPointWithinFluid(pos, bb.field_72336_d, bb.field_72338_b, bb.field_72337_e, bb.field_72334_f, (IExtendedBlockState)extendedState, checkCache);
    }

    static boolean isPointWithinFluid(@Nonnull BlockPos pos, double xIn, double minY, double maxY, double zIn, @Nonnull IExtendedBlockState state, boolean checkCache) {
        float[][] corners = new float[2][2];
        corners[0][0] = ((Float)state.getValue((IUnlistedProperty)BlockFluidBase.LEVEL_CORNERS[0])).floatValue();
        corners[0][1] = ((Float)state.getValue((IUnlistedProperty)BlockFluidBase.LEVEL_CORNERS[1])).floatValue();
        corners[1][1] = ((Float)state.getValue((IUnlistedProperty)BlockFluidBase.LEVEL_CORNERS[2])).floatValue();
        corners[1][0] = ((Float)state.getValue((IUnlistedProperty)BlockFluidBase.LEVEL_CORNERS[3])).floatValue();
        double x = MathHelper.func_151237_a((double)xIn, (double)pos.func_177958_n(), (double)(pos.func_177958_n() + 1)) - (double)pos.func_177958_n();
        double z = MathHelper.func_151237_a((double)zIn, (double)pos.func_177952_p(), (double)(pos.func_177952_p() + 1)) - (double)pos.func_177952_p();
        double x_weight_0 = 1.0 - x;
        double x_weight_1 = x;
        double z_weight_0 = 1.0 - z;
        double z_weight_1 = z;
        double fluidHeightAtPoint = (double)corners[0][0] * x_weight_0 * z_weight_0 + (double)corners[0][1] * x_weight_0 * z_weight_1 + (double)corners[1][1] * x_weight_1 * z_weight_1 + (double)corners[1][0] * x_weight_1 * z_weight_0;
        return FluidCollisionHandler.isYWithinFluid(FluidloggedUtils.getFluidFromState((IBlockState)state), pos, minY, maxY, FluidCollisionHandler.applyQolOffset(fluidHeightAtPoint), checkCache);
    }

    static boolean isWithinFluid(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos, double x, double y, double z, @Nullable IBlockState stateIn, @Nonnull AxisAlignedBB bb, @Nullable Entity entity, boolean checkCache) {
        if (FluidloggedAPIConfig.fancyFluidEntityCollision.test(bb, entity) && IWorldProvider.getWorld(worldIn).func_175707_a(pos.func_177982_a(-1, -1, -1), pos.func_177982_a(1, 1, 1))) {
            IBlockAccess access = worldIn instanceof World ? new FluidCache(worldIn, (Vec3i)pos, 1, 1) : worldIn;
            IBlockState state = stateIn != null ? stateIn : FluidloggedUtils.getFluidOrReal(access, pos);
            IBlockState extendedState = state.func_177230_c().getExtendedState(state, access, pos);
            return extendedState instanceof IExtendedBlockState ? FluidCollisionHandler.isPointWithinFluid(pos, x, y, y, z, (IExtendedBlockState)extendedState, checkCache) : FluidCollisionHandler.isYWithinFluidEstimate(access, pos, y, y, state, checkCache);
        }
        IBlockAccess access = worldIn instanceof World ? new FluidCache(worldIn, (Vec3i)pos, 0, 1) : worldIn;
        return FluidCollisionHandler.isYWithinFluidEstimate(access, pos, y, y, stateIn != null ? stateIn : FluidloggedUtils.getFluidOrReal(access, pos), checkCache);
    }

    static boolean isYWithinFluidEstimate(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, double minY, double maxY, @Nonnull IBlockState state, boolean checkCache) {
        return FluidCollisionHandler.isYWithinFluid(FluidloggedUtils.getFluidFromState(state), pos, minY, maxY, FluidCollisionHandler.applyQolOffset(FluidCollisionHandler.getFilledPercentage(FluidState.of(state), world, pos)), checkCache);
    }

    static boolean isYWithinFluid(@Nullable Fluid fluid, @Nonnull BlockPos pos, double minY, double maxY, double fluidHeight, boolean checkCache) {
        IWaterHeight waterHeight;
        boolean isWithin;
        boolean gas;
        boolean bl = gas = fluid != null && fluid.isLighterThanAir();
        boolean bl2 = gas ? maxY > (double)(pos.func_177956_o() + 1) - fluidHeight && minY < (double)(pos.func_177956_o() + 1) : (isWithin = minY < (double)pos.func_177956_o() + fluidHeight && maxY > (double)pos.func_177956_o());
        if (!isWithin) {
            return false;
        }
        if (checkCache && FluidloggedAPIConfig.ignoreLowFluidCollision && (waterHeight = cacheHeight.get()) != null) {
            IConfigFluidBox.HeightBox box = waterHeight.getBox();
            double height = Math.min((double)pos.func_177956_o() + fluidHeight - minY, 1.0);
            if (box == null) {
                waterHeight.setBox(new IConfigFluidBox.HeightBox(gas ? 1.0 - height : 0.0, gas ? 1.0 : height));
            } else if (box.min != 0.0 || box.max != 1.0) {
                waterHeight.setBox(new IConfigFluidBox.HeightBox(gas ? Math.min(box.min, 1.0 - height) : 0.0, gas ? 1.0 : Math.max(box.max, height)));
            }
        }
        return true;
    }

    public static double applyQolOffset(double fluidHeight) {
        double qolOffset = 0.015;
        return (double)((int)fluidHeight) == fluidHeight ? fluidHeight : fluidHeight - 0.015;
    }

    public static float getFilledPercentage(@Nonnull FluidState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        if (state.getBlock() instanceof BlockLiquid) {
            return BlockLiquid.func_190973_f((IBlockState)state.getState(), (IBlockAccess)world, (BlockPos)pos);
        }
        float remaining = state.getBlock() instanceof BlockFluidBase ? ((BlockFluidBase)state.getBlock()).getFilledPercentage(world, pos) : state.getFluidBlock().getFilledPercentage(IWorldProvider.getWorld(world), pos);
        float filled = (float)((int)remaining) == remaining ? remaining : remaining * state.getQuantaFraction();
        return filled < 0.0f ? 1.0f - filled : filled;
    }
}

