/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.fluid.util;

import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.api.world.IBlockAccessWrapper;
import git.jbredwards.fluidlogged_api.api.world.IChunkProvider;
import git.jbredwards.fluidlogged_api.api.world.IFluidStateProvider;
import git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.world.PluginWorld;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class FluidCache
extends IBlockAccessWrapper.Impl {
    @Nonnull
    protected final OptionalChunk[] chunks;
    @Nonnull
    public final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
    public final int minX;
    public final int minY;
    public final int minZ;
    public final int maxX;
    public final int maxY;
    public final int maxZ;
    public final int cMinX;
    public final int cMinZ;
    public final int cMaxX;
    public final int cMaxZ;

    public FluidCache(@Nonnull IBlockAccess accessIn, @Nonnull Vec3i pos, int radiusXZ, int radiusY) {
        this(accessIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), radiusXZ, radiusY);
    }

    public FluidCache(@Nonnull IBlockAccess accessIn, int originX, int originY, int originZ, int radiusXZ, int radiusY) {
        this(accessIn, originX - radiusXZ, originX + radiusXZ, originY - radiusY, originY + radiusY, originZ - radiusXZ, originZ + radiusXZ);
    }

    public FluidCache(@Nonnull IBlockAccess accessIn, int minXIn, int maxXIn, int minYIn, int maxYIn, int minZIn, int maxZIn) {
        super(accessIn);
        this.minX = minXIn;
        this.minY = minYIn;
        this.minZ = minZIn;
        this.maxX = maxXIn;
        this.maxY = maxYIn;
        this.maxZ = maxZIn;
        this.cMinX = this.minX >> 4;
        this.cMinZ = this.minZ >> 4;
        this.cMaxX = this.maxX >> 4;
        this.cMaxZ = this.maxZ >> 4;
        this.chunks = new OptionalChunk[(this.cMaxX - this.cMinX + 1) * (this.cMaxZ - this.cMinZ + 1)];
    }

    public FluidCache(@Nonnull IBlockAccess accessIn, @Nonnull AxisAlignedBB box) {
        this(accessIn, MathHelper.func_76128_c((double)box.field_72340_a), MathHelper.func_76143_f((double)box.field_72336_d), MathHelper.func_76128_c((double)box.field_72338_b), MathHelper.func_76143_f((double)box.field_72337_e), MathHelper.func_76128_c((double)box.field_72339_c), MathHelper.func_76143_f((double)box.field_72334_f));
    }

    @Nonnull
    public BlockPos.MutableBlockPos offset(@Nonnull Vec3i origin, @Nonnull Vec3i direction) {
        return this.offset(origin.func_177958_n(), origin.func_177956_o(), origin.func_177952_p(), direction);
    }

    @Nonnull
    public BlockPos.MutableBlockPos offset(int originX, int originY, int originZ, @Nonnull Vec3i direction) {
        return this.mutablePos.func_181079_c(originX + direction.func_177958_n(), originY + direction.func_177956_o(), originZ + direction.func_177952_p());
    }

    @Nonnull
    public FluidState getFluidOrReal(@Nonnull Vec3i pos) {
        return this.getFluidOrReal(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Nonnull
    public FluidState getFluidOrReal(int x, int y, int z) {
        return FluidloggedUtils.getFluidState(this.wrapped, (BlockPos)this.mutablePos.func_181079_c(x, y, z));
    }

    @Override
    @Nonnull
    public IBlockState func_180495_p(@Nonnull BlockPos pos) {
        return this.getBlockState(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Nonnull
    public IBlockState getBlockState(int x, int y, int z) {
        Chunk chunk = this.getChunk(x >> 4, z >> 4);
        return chunk != null ? chunk.func_186032_a(x, y, z) : this.wrapped.func_180495_p((BlockPos)this.mutablePos.func_181079_c(x, y, z));
    }

    @Override
    @Nullable
    public Chunk getChunk(int chunkX, int chunkZ) {
        int index;
        if (chunkX < this.cMinX || chunkX > this.cMaxX || chunkZ < this.cMinZ || chunkZ > this.cMaxZ || !(this.wrapped instanceof IChunkProvider)) {
            return null;
        }
        return (this.chunks[index = (chunkZ - this.cMinZ) * (this.cMaxX - this.cMinX + 1) + chunkX - this.cMinX] != null ? this.chunks[index] : new OptionalChunk((Chunk)((IChunkProvider)this.wrapped).getChunk((int)chunkX, (int)chunkZ))).chunk;
    }

    @Override
    @Nonnull
    public FluidState getFluidState(int x, int y, int z) {
        if (!(this.wrapped instanceof IFluidStateProvider)) {
            return FluidState.EMPTY;
        }
        Chunk chunk = this.getChunk(x >> 4, z >> 4);
        return chunk != null ? FluidState.getFromProvider((ICapabilityProvider)chunk, x, y, z) : ((IFluidStateProvider)this.wrapped).getFluidState(x, y, z);
    }

    @Override
    @Nullable
    public TileEntity func_175625_s(@Nonnull BlockPos pos) {
        World world = this.getWorld();
        if (world.field_147481_N) {
            TileEntity pending = world.func_189508_F(pos);
            if (pending != null) {
                return pending;
            }
            Chunk chunk = this.getChunk((Vec3i)pos);
            return chunk != null ? chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.IMMEDIATE) : null;
        }
        Chunk chunk = this.getChunk((Vec3i)pos);
        if (chunk == null) {
            return world.func_189508_F(pos);
        }
        TileEntity here = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.IMMEDIATE);
        return here != null ? here : world.func_189508_F(pos);
    }

    @Override
    public int func_175627_a(@Nonnull BlockPos pos, @Nonnull EnumFacing direction) {
        return PluginWorld.Hooks.getStrongPower(this, pos, direction);
    }

    @Override
    public boolean func_175623_d(@Nonnull BlockPos pos) {
        IBlockState state = this.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)this, pos);
    }

    protected static final class OptionalChunk {
        @Nullable
        public final Chunk chunk;

        public OptionalChunk(@Nullable Chunk chunkIn) {
            this.chunk = chunkIn;
        }
    }
}

