/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.fluid.util;

import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.FluidCache;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public interface IFluidNeighborInfo {
    @Nonnull
    public FluidState getOrigin();

    public int getOriginX();

    public int getOriginY();

    public int getOriginZ();

    @Nonnull
    default public BlockPos getPosI(int x, int y, int z) {
        return this.getPosIB(this.getXI(x), this.getYI(y), this.getZI(z));
    }

    @Nonnull
    default public BlockPos getPosIB(int xi, int yi, int zi) {
        return this.getCache().mutablePos.func_181079_c(this.getXIB(xi), this.getYIB(yi), this.getZIB(zi));
    }

    default public int getXB(int x) {
        return this.getOriginX() + x;
    }

    default public int getYB(int y) {
        return this.getOriginY() - y * this.getOrigin().getDensityDir();
    }

    default public int getZB(int z) {
        return this.getOriginZ() + z;
    }

    default public int getXI(int x) {
        return this.getOriginX() + x - this.getCache().minX;
    }

    default public int getYI(int y) {
        return this.getOriginY() + y - this.getCache().minY;
    }

    default public int getZI(int z) {
        return this.getOriginZ() + z - this.getCache().minZ;
    }

    default public int getXIB(int xi) {
        return xi + this.getCache().minX;
    }

    default public int getYIB(int yi) {
        return this.getYB(yi + this.getCache().minY - this.getOriginY());
    }

    default public int getZIB(int zi) {
        return zi + this.getCache().minZ;
    }

    @Nonnull
    public FluidCache getCache();

    @Nonnull
    default public IBlockState getBlockStateI(int xi, int yi, int zi) {
        return this.getCache().getBlockState(this.getXIB(xi), this.getYIB(yi), this.getZIB(zi));
    }

    @Nonnull
    default public FluidState getFluidStateI(int xi, int yi, int zi) {
        return this.getCache().getFluidOrReal(this.getXIB(xi), this.getYIB(yi), this.getZIB(zi));
    }

    default public boolean canFluidFlowI(int xi, int yi, int zi, @Nonnull EnumFacing side) {
        return FluidloggedUtils.canFluidFlow(this.getCache(), this.getPosIB(xi, yi, zi), this.getCache().func_180495_p((BlockPos)this.getCache().mutablePos), side);
    }

    default public boolean isCompatibleFluidI(int xi, int yi, int zi) {
        return FluidloggedUtils.isCompatibleFluid(this.getOrigin(), this.getFluidStateI(xi, yi, zi));
    }

    @Nonnull
    default public IBlockState getBlockState(int x, int y, int z) {
        return this.getCache().getBlockState(this.getXB(x), this.getYB(y), this.getZB(z));
    }

    @Nonnull
    default public FluidState getFluidState(int x, int y, int z) {
        return this.getCache().getFluidOrReal(this.getXB(x), this.getYB(y), this.getZB(z));
    }

    default public boolean canFluidFlow(int x, int y, int z, @Nonnull EnumFacing side) {
        return this.canFluidFlowI(this.getXI(x), this.getYI(y), this.getZI(z), side);
    }

    default public boolean isCompatibleFluid(int x, int y, int z) {
        return this.isCompatibleFluidI(this.getXI(x), this.getYI(y), this.getZI(z));
    }
}

