/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.tile;

import micdoodle8.mods.galacticraft.api.power.EnergySource;
import micdoodle8.mods.galacticraft.api.power.ILaserNode;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.energy.tile.EnergyStorage;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityBeamOutput;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBeamReflector
extends TileEntityBeamOutput
implements ILaserNode {
    public Vector3 color = new Vector3(0.0, 1.0, 0.0);
    private EnergyStorage storage = new EnergyStorage(10.0f, 1.0f);
    private AxisAlignedBB renderAABB;

    public TileEntityBeamReflector() {
        super("container.beam_reflector.name");
    }

    @Override
    public Vector3 getInputPoint() {
        float distance = 0.15f;
        Vector3 deviation = new Vector3(Math.sin(Math.toRadians(this.yaw - 180.0f)) * (double)distance, 0.0, Math.cos(Math.toRadians(this.yaw - 180.0f)) * (double)distance);
        Vector3 headVec = new Vector3((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.56614, (double)this.func_174877_v().func_177952_p() + 0.5);
        headVec.translate(deviation.clone().invert());
        return headVec;
    }

    @Override
    public Vector3 getOutputPoint(boolean offset) {
        return new Vector3((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.56614, (double)this.func_174877_v().func_177952_p() + 0.5);
    }

    @Override
    public double getPacketRange() {
        return 24.0;
    }

    @Override
    public int getPacketCooldown() {
        return 3;
    }

    @Override
    public boolean isNetworkedTile() {
        return true;
    }

    @Override
    public Vector3 getColor() {
        return this.color;
    }

    @Override
    public boolean canConnectTo(ILaserNode laserNode) {
        return this.color.equals(laserNode.getColor());
    }

    @Override
    public float receiveEnergyGC(EnergySource from, float amount, boolean simulate) {
        if (this.getTarget() != null) {
            if (from instanceof EnergySource.EnergySourceWireless) {
                if (((EnergySource.EnergySourceWireless)from).nodes.contains(this.getTarget())) {
                    return 0.0f;
                }
                ((EnergySource.EnergySourceWireless)from).nodes.add(this);
                return this.getTarget().receiveEnergyGC(from, amount, simulate);
            }
            return 0.0f;
        }
        return this.storage.receiveEnergyGC(amount, simulate);
    }

    @Override
    public float extractEnergyGC(EnergySource from, float amount, boolean simulate) {
        return 0.0f;
    }

    @Override
    public boolean nodeAvailable(EnergySource from) {
        return from instanceof EnergySource.EnergySourceWireless;
    }

    @Override
    public float getEnergyStoredGC(EnergySource from) {
        return this.storage.getEnergyStoredGC();
    }

    @Override
    public float getMaxEnergyStoredGC(EnergySource from) {
        return this.storage.getCapacityGC();
    }

    @Override
    public void setTarget(ILaserNode target) {
        super.setTarget(target);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 2, 1));
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 16384.0;
    }
}

