/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.miccore;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.miccore.ConfigManagerMicCore;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.IFMLCallHook;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@IFMLLoadingPlugin.TransformerExclusions(value={"micdoodle8.mods.miccore"})
@IFMLLoadingPlugin.MCVersion(value="1.12.2")
public class MicdoodlePlugin
implements IFMLLoadingPlugin,
IFMLCallHook {
    public static Logger miccoreLogger = LogManager.getLogger((String)"MicdoodleCore");
    public static boolean hasRegistered = false;
    public static final String mcVersion = "1.12.2";
    public static File mcDir;
    public static File canonicalConfigDir;
    private static Constructor<?> sleepCancelledConstructor;
    private static Constructor<?> orientCameraConstructor;
    private static String eventContainerClass;

    public String[] getASMTransformerClass() {
        String[] asmStrings = new String[]{"micdoodle8.mods.miccore.MicdoodleTransformer"};
        if (!hasRegistered) {
            List<String> asm = Arrays.asList(asmStrings);
            for (String s : asm) {
                try {
                    Class<?> c = Class.forName(s);
                    if (c == null) continue;
                    miccoreLogger.info("Successfully Registered Transformer");
                }
                catch (Exception ex) {
                    miccoreLogger.error("Error while running transformer " + s);
                    return null;
                }
            }
            hasRegistered = true;
        }
        return asmStrings;
    }

    public String getModContainerClass() {
        return "micdoodle8.mods.miccore.MicdoodleModContainer";
    }

    public String getSetupClass() {
        return "micdoodle8.mods.miccore.MicdoodlePlugin";
    }

    public Void call() throws Exception {
        return null;
    }

    public static void onSleepCancelled() {
        try {
            if (sleepCancelledConstructor == null) {
                sleepCancelledConstructor = Class.forName(eventContainerClass + "$SleepCancelledEvent").getConstructor(new Class[0]);
            }
            MinecraftForge.EVENT_BUS.post((Event)sleepCancelledConstructor.newInstance(new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void orientCamera() {
        try {
            if (orientCameraConstructor == null) {
                orientCameraConstructor = Class.forName(eventContainerClass + "$OrientCameraEvent").getConstructor(new Class[0]);
            }
            MinecraftForge.EVENT_BUS.post((Event)orientCameraConstructor.newInstance(new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getAccessTransformerClass() {
        boolean deobfuscated = true;
        try {
            deobfuscated = Launch.classLoader.getClassBytes("net.minecraft.world.World") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (deobfuscated) {
            return "micdoodle8.mods.miccore.MicdoodleAccessTransformerDeObf";
        }
        return "micdoodle8.mods.miccore.MicdoodleAccessTransformer";
    }

    public void injectData(Map<String, Object> data) {
        if (data.containsKey("mcLocation")) {
            String canonicalConfigPath;
            mcDir = (File)data.get("mcLocation");
            File configDir = new File(mcDir, "config");
            try {
                canonicalConfigPath = configDir.getCanonicalPath();
                canonicalConfigDir = configDir.getCanonicalFile();
            }
            catch (IOException ioe) {
                throw new LoaderException((Throwable)ioe);
            }
            if (!canonicalConfigDir.exists()) {
                miccoreLogger.debug("No config directory found, creating one: %s", (Object)canonicalConfigPath);
                boolean dirMade = canonicalConfigDir.mkdir();
                if (!dirMade) {
                    miccoreLogger.error("Unable to create the config directory %s", (Object)canonicalConfigPath);
                    throw new LoaderException();
                }
                miccoreLogger.info("Config directory created successfully");
            }
            ConfigManagerMicCore.init();
        }
    }

    static {
        eventContainerClass = "micdoodle8.mods.galacticraft.core.event.EventHandlerGC";
    }
}

