/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.mj;

import buildcraft.api.mj.MjAPI;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public class MjBattery
implements INBTSerializable<NBTTagCompound> {
    private final long capacity;
    private long microJoules = 0L;

    public MjBattery(long capacity) {
        this.capacity = capacity;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74772_a("stored", this.microJoules);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.microJoules = nbt.func_74763_f("stored");
    }

    public void writeToBuffer(ByteBuf buffer) {
        buffer.writeLong(this.microJoules);
    }

    public void readFromBuffer(ByteBuf buffer) {
        this.microJoules = buffer.readLong();
    }

    public long addPower(long microJoulesToAdd, boolean simulate) {
        if (!simulate) {
            this.microJoules += microJoulesToAdd;
        }
        return 0L;
    }

    public long addPowerChecking(long microJoulesToAdd, boolean simulate) {
        if (this.isFull()) {
            return microJoulesToAdd;
        }
        if (microJoulesToAdd + this.microJoules <= this.capacity) {
            if (!simulate) {
                this.microJoules += microJoulesToAdd;
            }
            return 0L;
        }
        long difference = microJoulesToAdd + this.microJoules - this.capacity;
        if (!simulate) {
            this.microJoules = this.capacity;
        }
        return difference;
    }

    public long extractAll() {
        return this.extractPower(0L, this.microJoules);
    }

    public boolean extractPower(long power) {
        return this.extractPower(power, power) > 0L;
    }

    public long extractPower(long min, long max) {
        if (this.microJoules < min) {
            return 0L;
        }
        long extracting = Math.min(this.microJoules, max);
        this.microJoules -= extracting;
        return extracting;
    }

    public boolean isFull() {
        return this.microJoules >= this.capacity;
    }

    public long getStored() {
        return this.microJoules;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void tick(World world, BlockPos position) {
        this.tick(world, new Vec3d((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5));
    }

    public void tick(World world, Vec3d position) {
        if (this.microJoules > this.capacity * 2L) {
            this.losePower(world, position);
        }
    }

    protected void losePower(World world, Vec3d position) {
        long diff = this.microJoules - this.capacity * 2L;
        long lost = MjBattery.ceilDivide(diff, 32L);
        this.microJoules -= lost;
        MjAPI.EFFECT_MANAGER.createPowerLossEffect(world, position, lost);
    }

    private static long ceilDivide(long val, long by) {
        return val / by + (long)(val % by == 0L ? 0 : 1);
    }

    public String getDebugString() {
        return MjAPI.formatMj(this.microJoules) + " / " + MjAPI.formatMj(this.capacity) + " MJ";
    }
}

