/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.mj;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.MjAPI;
import javax.annotation.Nonnull;
import net.minecraftforge.energy.IEnergyStorage;

public class RfWrapperReceiver
implements IMjReceiver {
    private IEnergyStorage storage;

    public RfWrapperReceiver(IEnergyStorage storage) {
        this.storage = storage;
    }

    @Override
    public boolean canConnect(@Nonnull IMjConnector other) {
        return this.storage.canReceive();
    }

    @Override
    public long getPowerRequested() {
        int rfRequested = this.storage.getMaxEnergyStored() - this.storage.getEnergyStored();
        return (long)rfRequested * MjAPI.MJ / (long)MjAPI.rfPerMj;
    }

    @Override
    public long receivePower(long microJoules, boolean simulate) {
        int rf = (int)(microJoules * (long)MjAPI.rfPerMj / MjAPI.MJ);
        int rfAccepted = this.storage.receiveEnergy(rf, simulate);
        int excessRf = rf - rfAccepted;
        return (long)excessRf * MjAPI.MJ / (long)MjAPI.rfPerMj;
    }
}

