/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.compat;

import buildcraft.api.core.BCLog;
import buildcraft.core.BCCoreConfig;
import buildcraft.core.compat.CompatModuleBase;
import buildcraft.core.compat.module.crafttweaker.CompatModuleCraftTweaker;
import buildcraft.core.compat.module.forestry.CompatModuleForestry;
import buildcraft.core.compat.module.ic2.CompatModuleIndustrialCraft2;
import buildcraft.core.compat.module.theoneprobe.CompatModuleTheOneProbe;
import buildcraft.core.compat.network.CompatGui;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

@Mod(modid="buildcraftcompat", name="BuildCraft Compat", version="8.0.9", updateJSON="https://mod-buildcraft.com/version/versions-compat.json", acceptedMinecraftVersions="[1.12.2]", dependencies="required-after:forge@[14.23.5.2847,);required-after:buildcraftcore@[$bc_version,);after:buildcrafttransport;after:buildcraftbuilders;after:buildcraftsilicon;after:theoneprobe;after:forestry;after:crafttweaker;after:ic2")
public class BCCompat {
    static final String DEPENDENCIES = "required-after:forge@[14.23.5.2847,);required-after:buildcraftcore@[$bc_version,);after:buildcrafttransport;after:buildcraftbuilders;after:buildcraftsilicon;after:theoneprobe;after:forestry;after:crafttweaker;after:ic2";
    public static final String MODID = "buildcraftcompat";
    public static final String VERSION = "8.0.9";
    @Mod.Instance(value="buildcraftcompat")
    public static BCCompat instance;
    private static final Map<String, CompatModuleBase> modules;

    private static void offerAndPreInitModule(CompatModuleBase module) {
        String cModId = module.compatModId();
        if (module.canLoad()) {
            Property prop = BCCoreConfig.config.get("modules", cModId, true);
            prop.setComment("Enable compat for " + cModId + "?");
            if (prop.getBoolean(true)) {
                modules.put(cModId, module);
                BCLog.logger.info("[compat]   + " + cModId);
                module.preInit();
            } else {
                BCLog.logger.info("[compat]   x " + cModId + " (It has been disabled in the config)");
            }
        } else {
            BCLog.logger.info("[compat]   x " + cModId + " (It cannot load)");
        }
    }

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent evt) {
        BCCompat.offerAndPreInitModule(new CompatModuleForestry());
        BCCompat.offerAndPreInitModule(new CompatModuleTheOneProbe());
        BCCompat.offerAndPreInitModule(new CompatModuleCraftTweaker());
        BCCompat.offerAndPreInitModule(new CompatModuleIndustrialCraft2());
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent evt) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)CompatGui.guiHandlerProxy);
        for (CompatModuleBase m : modules.values()) {
            m.init();
        }
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent evt) {
        for (CompatModuleBase m : modules.values()) {
            m.postInit();
        }
    }

    static {
        modules = new HashMap<String, CompatModuleBase>();
    }
}

