/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.compat.module.crafttweaker;

import buildcraft.api.mj.MjAPI;
import buildcraft.api.recipes.IngredientStack;
import buildcraft.lib.recipe.IntegrationRecipeBasic;
import buildcraft.lib.recipe.IntegrationRecipeRegistry;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.buildcraft.IntegrationTable")
@ModOnly(value="buildcraftsilicon")
public class IntegrationTable {
    private static int ids;

    @ZenMethod
    public static void addRecipe(IItemStack output, int power, IIngredient target, IIngredient[] ingredients) {
        IntegrationTable.addRecipe0("auto_" + ids++, output, power, target, ingredients);
    }

    @ZenMethod
    public static void addRecipe(String name, IItemStack output, int power, IIngredient target, IIngredient[] ingredients) {
        IntegrationTable.addRecipe0("custom/" + name, output, power, target, ingredients);
    }

    private static void addRecipe0(String name, IItemStack output, int power, IIngredient target, IIngredient[] ingredients) {
        CraftTweakerAPI.apply((IAction)new AddRecipeAction(name, output, power, target, ingredients));
    }

    private static class AddRecipeAction
    implements IAction {
        private final ItemStack output;
        private final ResourceLocation name;
        private final long requiredMj;
        private final List<IngredientStack> requiredStacks = new ArrayList<IngredientStack>();
        private final IngredientStack target;

        public AddRecipeAction(String name, IItemStack output, int power, IIngredient target, IIngredient[] ingredients) {
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
            this.target = new IngredientStack(CraftTweakerMC.getIngredient((IIngredient)target), Math.max(1, target.getAmount()));
            for (IIngredient ctIng : ingredients) {
                Ingredient ingredient = CraftTweakerMC.getIngredient((IIngredient)ctIng);
                this.requiredStacks.add(new IngredientStack(ingredient, Math.max(1, ctIng.getAmount())));
            }
            this.requiredMj = (long)power * MjAPI.MJ / (long)MjAPI.rfPerMj;
            this.name = new ResourceLocation("crafttweaker", name);
        }

        public void apply() {
            IntegrationRecipeRegistry.INSTANCE.recipes.put(this.name, new IntegrationRecipeBasic(this.name, this.requiredMj, this.target, this.requiredStacks, this.output));
        }

        public String describe() {
            return "Adding assembly table recipe for " + this.output;
        }
    }
}

