/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.compat.module.forestry.pipe;

import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.api.transport.pipe.PipeDefinition;
import buildcraft.core.compat.module.forestry.pipe.PipeBehaviourPropolis;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.lib.registry.CreativeTabManager;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ForestryPipes {
    public static Item pipeItemPropolis;
    public static PipeDefinition pipeDefinitionPropolis;

    public static void preInit() {
        MinecraftForge.EVENT_BUS.register(ForestryPipes.class);
        String[] textureSuffixes = new String[8];
        textureSuffixes[0] = "";
        textureSuffixes[7] = "_itemstack";
        for (EnumFacing face : EnumFacing.field_82609_l) {
            textureSuffixes[face.ordinal() + 1] = "_" + face.func_176610_l();
        }
        pipeDefinitionPropolis = new PipeDefinition.PipeDefinitionBuilder().id("forestry_propolis").texPrefix("propolis").texSuffixes(textureSuffixes).logic(PipeBehaviourPropolis::new, PipeBehaviourPropolis::new).flowItem().define();
        PipeApi.pipeRegistry.createUnnamedItemForPipe(pipeDefinitionPropolis, item -> {
            pipeItemPropolis = item;
            item.setRegistryName("pipe_item_propolis");
            item.func_77655_b("buildcraftPipe.pipeitemspropolis");
            item.func_77637_a(CreativeTabManager.getTab("buildcraft.pipes"));
        });
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        Item propolis = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("forestry:propolis"));
        if (propolis != null && propolis != Items.field_190931_a) {
            ForestryPipes.addPipeRecipe(pipeItemPropolis, propolis, Items.field_151045_i);
        }
    }

    private static void addPipeRecipe(Item pipe, Object surround) {
        ForestryPipes.addPipeRecipe(pipe, surround, surround);
    }

    private static void addPipeRecipe(Item pipe, Object left, Object right) {
        if (pipe == null) {
            return;
        }
        ItemStack result = new ItemStack(pipe, 8);
        ShapedOreRecipe recipe = new ShapedOreRecipe(pipe.getRegistryName(), result, new Object[]{"lgr", Character.valueOf('l'), left, Character.valueOf('r'), right, Character.valueOf('g'), "blockGlassColorless"});
        recipe.setRegistryName(new ResourceLocation(pipe.getRegistryName() + "_colorless"));
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
        for (EnumDyeColor colour : EnumDyeColor.values()) {
            ItemStack resultStack = new ItemStack(pipe, 8, colour.func_176765_a() + 1);
            ShapedOreRecipe colorRecipe = new ShapedOreRecipe(pipe.getRegistryName(), resultStack, new Object[]{"lgr", Character.valueOf('l'), left, Character.valueOf('r'), right, Character.valueOf('g'), "blockGlass" + ColourUtil.getName(colour)});
            colorRecipe.setRegistryName(new ResourceLocation(pipe.getRegistryName() + "_" + colour));
            ForgeRegistries.RECIPES.register((IForgeRegistryEntry)colorRecipe);
        }
    }
}

