/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.compat.module.ic2.exp;

import buildcraft.api.statements.IActionExternal;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.core.BCCoreSprites;
import buildcraft.core.compat.module.ic2.exp.ExpIC2Statements;
import buildcraft.core.statements.BCStatement;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import ic2.core.block.wiring.TileEntityElectricBlock;
import ic2.core.init.Localization;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ExpActionSetRedstoneMode
extends BCStatement
implements IActionExternal {
    private final byte mode;

    public ExpActionSetRedstoneMode(byte mode) {
        super("rs." + mode);
        this.mode = mode;
    }

    @Override
    public String getDescription() {
        return "Set " + Localization.translate((String)("ic2.EUStorage.gui.mod.redstone" + this.mode));
    }

    @Override
    public void actionActivate(TileEntity target, EnumFacing side, IStatementContainer source, IStatementParameter[] parameters) {
        if (target instanceof TileEntityElectricBlock) {
            TileEntityElectricBlock block = (TileEntityElectricBlock)target;
            if (block.redstoneMode != this.mode) {
                block.redstoneMode = this.mode;
                block.func_70296_d();
                World w = block.func_145831_w();
                if (w != null) {
                    BlockPos pos = block.func_174877_v();
                    IBlockState state = w.func_180495_p(pos);
                    block.func_145831_w().func_184138_a(pos, state, state, 3);
                }
            }
        }
    }

    public static boolean canActivate(TileEntity tile) {
        return tile instanceof TileEntityElectricBlock;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SpriteHolderRegistry.SpriteHolder getSprite() {
        return BCCoreSprites.REDSTONE;
    }

    @Override
    public IStatement[] getPossible() {
        return ExpIC2Statements.REDSTONE_MODE;
    }
}

