/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.compat.module.ic2.exp;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.core.BCCoreSprites;
import buildcraft.core.compat.module.ic2.exp.ExpIC2Statements;
import buildcraft.core.statements.BCStatement;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.misc.LocaleUtil;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.comp.Energy;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class ExpTriggerEU
extends BCStatement
implements ITriggerExternal {
    private final boolean high;

    public ExpTriggerEU(boolean high) {
        super("buildcraft:energyStoredEU" + (high ? "high" : "low"));
        this.high = high;
    }

    @Override
    public SpriteHolderRegistry.SpriteHolder getSprite() {
        return this.high ? BCCoreSprites.TRIGGER_POWER_HIGH : BCCoreSprites.TRIGGER_POWER_LOW;
    }

    @Override
    public String getDescription() {
        return LocaleUtil.localize("gate.trigger.machine.energyStored." + (this.high ? "high" : "low"));
    }

    private static Energy getEnergy(TileEntity tile) {
        if (tile instanceof TileEntityBlock && ((TileEntityBlock)tile).hasComponent(Energy.class)) {
            return (Energy)((TileEntityBlock)tile).getComponent(Energy.class);
        }
        return null;
    }

    public static boolean isTriggeringTile(TileEntity tile) {
        Energy energy = ExpTriggerEU.getEnergy(tile);
        if (energy != null) {
            return energy.getCapacity() > 0.0;
        }
        return false;
    }

    @Override
    public boolean isTriggerActive(TileEntity target, EnumFacing side, IStatementContainer source, IStatementParameter[] parameters) {
        Energy energy = ExpTriggerEU.getEnergy(target);
        if (energy != null) {
            double stored = energy.getEnergy();
            double max = energy.getCapacity();
            if (max > 0.0) {
                double level = stored / max;
                if (this.high) {
                    return level > 0.95;
                }
                return level < 0.05;
            }
        }
        return false;
    }

    @Override
    public IStatement[] getPossible() {
        return ExpIC2Statements.TRIGGER_EU;
    }
}

