/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.compat.module.jei.silicon;

import buildcraft.api.mj.MjAPI;
import buildcraft.api.recipes.IngredientStack;
import buildcraft.api.recipes.IntegrationRecipe;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WrapperIntegrationTable
implements IRecipeWrapper {
    public final IntegrationRecipe recipe;
    public final List<List<ItemStack>> inputs;
    public final ItemStack output;
    public final IDrawableAnimated progressBar;

    public WrapperIntegrationTable(IGuiHelper guiHelper, IntegrationRecipe recipe) {
        this.recipe = recipe;
        ArrayList _inputs = Lists.newArrayList();
        ArrayList<ItemStack> inner1 = new ArrayList<ItemStack>();
        for (ItemStack matching : recipe.getCenterStack().ingredient.func_193365_a()) {
            matching = matching.func_77946_l();
            matching.func_190920_e(recipe.getCenterStack().count);
            inner1.add(matching);
        }
        _inputs.add(inner1);
        for (IngredientStack in : recipe.getSurrounding()) {
            ArrayList<ItemStack> inner = new ArrayList<ItemStack>();
            for (ItemStack matching : in.ingredient.func_193365_a()) {
                matching = matching.func_77946_l();
                matching.func_190920_e(in.count);
                inner.add(matching);
            }
            _inputs.add(inner);
        }
        this.inputs = ImmutableList.copyOf((Collection)_inputs);
        this.output = recipe.getOutput();
        ResourceLocation backgroundLocation = new ResourceLocation("buildcraftsilicon", "textures/gui/integration_table.png");
        IDrawableStatic progressDrawable = guiHelper.createDrawable(backgroundLocation, 176, 3, 4, 70, 0, 0, 0, 0);
        this.progressBar = guiHelper.createAnimatedDrawable(progressDrawable, (int)Math.max(10L, recipe.getRequiredMicroJoules() / MjAPI.MJ / 50L), IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.progressBar.draw(minecraft, 156, 5);
        minecraft.field_71466_p.func_78276_b(MjAPI.formatRFFromMj(this.recipe.getRequiredMicroJoules()) + " RF", 81, 5, Color.gray.getRGB());
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Lists.newArrayList();
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

