/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.client.render;

import buildcraft.factory.BCFactoryBlocks;
import buildcraft.factory.BCFactoryModels;
import buildcraft.factory.tile.TileDistiller_BC8;
import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.client.render.fluid.FluidRenderer;
import buildcraft.lib.client.render.fluid.FluidSpriteType;
import buildcraft.lib.fluid.FluidSmoother;
import buildcraft.lib.misc.RenderUtil;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderDistiller
extends TileEntitySpecialRenderer<TileDistiller_BC8> {
    private static final Map<EnumFacing, TankRenderSizes> TANK_SIZES = new EnumMap<EnumFacing, TankRenderSizes>(EnumFacing.class);

    public void render(TileDistiller_BC8 tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        super.func_192841_a((TileEntity)tile, x, y, z, partialTicks, destroyStage, alpha);
        IBlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        if (state.func_177230_c() != BCFactoryBlocks.distiller) {
            return;
        }
        Profiler profiler = Minecraft.func_71410_x().field_71424_I;
        profiler.func_76320_a("bc");
        profiler.func_76320_a("distiller");
        int combinedLight = tile.func_145831_w().func_175626_b(tile.func_174877_v(), 0);
        EnumFacing face = (EnumFacing)state.func_177229_b(BlockBCBase_Neptune.PROP_FACING);
        TankRenderSizes sizes = TANK_SIZES.get(face);
        RenderHelper.func_74518_a();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        try (RenderUtil.AutoTessellator tess = RenderUtil.getThreadLocalUnusedTessellator();){
            BufferBuilder bb = tess.tessellator.func_178180_c();
            bb.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            bb.func_178969_c(x, y, z);
            profiler.func_76320_a("model");
            profiler.func_76320_a("compute");
            if (tile.clientModelData.hasNoNodes()) {
                tile.clientModelData.setNodes(BCFactoryModels.DISTILLER.createTickableNodes());
            }
            tile.setClientModelVariables(partialTicks);
            tile.clientModelData.refresh();
            MutableQuad[] quads = BCFactoryModels.DISTILLER.getCutoutQuads();
            profiler.func_76318_c("render");
            MutableQuad copy = new MutableQuad(0, null);
            int lightc = combinedLight;
            int light_block = lightc >> 4 & 0xF;
            int light_sky = lightc >> 20 & 0xF;
            for (MutableQuad q : quads) {
                copy.copyFrom(q);
                copy.maxLighti(light_block, light_sky);
                copy.multShade();
                copy.render(bb);
            }
            profiler.func_76319_b();
            profiler.func_76318_c("fluid");
            RenderDistiller.renderTank(sizes.tankIn, tile.smoothedTankIn, combinedLight, partialTicks, bb);
            RenderDistiller.renderTank(sizes.tankOutLiquid, tile.smoothedTankLiquidOut, combinedLight, partialTicks, bb);
            bb.func_178969_c(0.0, 0.0, 0.0);
            profiler.func_76318_c("draw");
            tess.tessellator.func_78381_a();
        }
        RenderHelper.func_74519_b();
        profiler.func_76319_b();
        profiler.func_76319_b();
        profiler.func_76319_b();
    }

    public static void renderTank(FluidRenderer.TankSize size, FluidSmoother tank, int combinedLight, float partialTicks, BufferBuilder bb) {
        FluidSmoother.FluidStackInterp fluid = tank.getFluidForRender(partialTicks);
        if (fluid == null || fluid.amount <= 0.0) {
            return;
        }
        int blockLight = fluid.fluid.getFluid().getLuminosity(fluid.fluid) & 0xF;
        FluidRenderer.vertex.lighti(combinedLight |= blockLight << 4);
        FluidRenderer.renderFluid(FluidSpriteType.STILL, fluid.fluid, fluid.amount, tank.getCapacity(), size.min, size.max, bb, null);
    }

    static {
        EnumFacing face = EnumFacing.WEST;
        FluidRenderer.TankSize tankLiquidOut = new FluidRenderer.TankSize(0, 0, 4, 8, 16, 12).shrink(0.015625);
        FluidRenderer.TankSize tankIn = new FluidRenderer.TankSize(8, 0, 0, 16, 16, 16).shrink(0.015625);
        TankRenderSizes sizes = new TankRenderSizes(tankIn, tankLiquidOut);
        for (int i = 0; i < 4; ++i) {
            TANK_SIZES.put(face, sizes);
            face = face.func_176746_e();
            sizes = sizes.rotateY();
        }
    }

    static class TankRenderSizes {
        final FluidRenderer.TankSize tankIn;
        final FluidRenderer.TankSize tankOutLiquid;

        public TankRenderSizes(FluidRenderer.TankSize tankIn, FluidRenderer.TankSize tankOutLiquid) {
            this.tankIn = tankIn;
            this.tankOutLiquid = tankOutLiquid;
        }

        public TankRenderSizes rotateY() {
            return new TankRenderSizes(this.tankIn.rotateY(), this.tankOutLiquid.rotateY());
        }
    }
}

