/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.block;

import buildcraft.lib.block.ILocalBlockUpdateSubscriber;
import buildcraft.lib.world.WorldEventListenerAdapter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;

public class LocalBlockUpdateNotifier {
    private static final Map<World, LocalBlockUpdateNotifier> instanceMap = new WeakHashMap<World, LocalBlockUpdateNotifier>();
    private final Set<ILocalBlockUpdateSubscriber> subscriberSet = new HashSet<ILocalBlockUpdateSubscriber>();

    private LocalBlockUpdateNotifier(World world) {
        WorldEventListenerAdapter worldEventListener = new WorldEventListenerAdapter(){

            @Override
            public void func_184376_a(@Nonnull World world, @Nonnull BlockPos eventPos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState, int flags) {
                LocalBlockUpdateNotifier.this.notifySubscribersInRange(world, eventPos, oldState, newState, flags);
            }
        };
        world.func_72954_a((IWorldEventListener)worldEventListener);
    }

    public static LocalBlockUpdateNotifier instance(World world) {
        if (!instanceMap.containsKey(world)) {
            instanceMap.put(world, new LocalBlockUpdateNotifier(world));
        }
        return instanceMap.get(world);
    }

    public void registerSubscriberForUpdateNotifications(ILocalBlockUpdateSubscriber subscriber) {
        this.subscriberSet.add(subscriber);
    }

    public void removeSubscriberFromUpdateNotifications(ILocalBlockUpdateSubscriber subscriber) {
        this.subscriberSet.remove(subscriber);
    }

    private void notifySubscribersInRange(World world, BlockPos eventPos, IBlockState oldState, IBlockState newState, int flags) {
        for (ILocalBlockUpdateSubscriber subscriber : this.subscriberSet) {
            BlockPos keyPos = subscriber.getSubscriberPos();
            int updateRange = subscriber.getUpdateRange();
            if (Math.abs(keyPos.func_177958_n() - eventPos.func_177958_n()) > updateRange || Math.abs(keyPos.func_177956_o() - eventPos.func_177956_o()) > updateRange || Math.abs(keyPos.func_177952_p() - eventPos.func_177952_p()) > updateRange) continue;
            subscriber.setWorldUpdated(world, eventPos, oldState, newState, flags);
        }
    }
}

