/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IDependancyVisitor;
import buildcraft.lib.expression.api.IDependantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionBi;
import buildcraft.lib.expression.node.value.NodeConstantBoolean;
import java.util.Objects;

public class NodeFuncDoubleToBoolean
extends NodeFuncBase
implements INodeFunc.INodeFuncBoolean {
    public final IFuncDoubleToBoolean function;
    private final StringFunctionBi stringFunction;

    public NodeFuncDoubleToBoolean(String name, IFuncDoubleToBoolean function) {
        this(function, (String a) -> "[ double -> boolean ] " + name + "(" + a + ")");
    }

    public NodeFuncDoubleToBoolean(IFuncDoubleToBoolean function, StringFunctionBi stringFunction) {
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction.apply("{A}");
    }

    @Override
    public NodeFuncDoubleToBoolean setNeverInline() {
        super.setNeverInline();
        return this;
    }

    @Override
    public IExpressionNode.INodeBoolean getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeDouble a = stack.popDouble();
        return this.create(a);
    }

    public FuncDoubleToBoolean create(IExpressionNode.INodeDouble argA) {
        return new FuncDoubleToBoolean(argA);
    }

    @FunctionalInterface
    public static interface IFuncDoubleToBoolean {
        public boolean apply(double var1);
    }

    public class FuncDoubleToBoolean
    implements IExpressionNode.INodeBoolean,
    IDependantNode,
    NodeFuncBase.IFunctionNode {
        public final IExpressionNode.INodeDouble argA;

        public FuncDoubleToBoolean(IExpressionNode.INodeDouble argA) {
            this.argA = argA;
        }

        @Override
        public boolean evaluate() {
            return NodeFuncDoubleToBoolean.this.function.apply(this.argA.evaluate());
        }

        @Override
        public IExpressionNode.INodeBoolean inline() {
            if (!NodeFuncDoubleToBoolean.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, a -> new FuncDoubleToBoolean((IExpressionNode.INodeDouble)a), a -> new FuncDoubleToBoolean((IExpressionNode.INodeDouble)a));
            }
            return NodeInliningHelper.tryInline(this, this.argA, a -> new FuncDoubleToBoolean((IExpressionNode.INodeDouble)a), a -> NodeConstantBoolean.of(NodeFuncDoubleToBoolean.this.function.apply(a.evaluate())));
        }

        @Override
        public void visitDependants(IDependancyVisitor visitor) {
            if (!NodeFuncDoubleToBoolean.this.canInline) {
                if (NodeFuncDoubleToBoolean.this.function instanceof IDependantNode) {
                    visitor.dependOn((IDependantNode)((Object)NodeFuncDoubleToBoolean.this.function));
                } else {
                    visitor.dependOnExplictly(this);
                }
            }
            visitor.dependOn((IExpressionNode)this.argA);
        }

        public String toString() {
            return NodeFuncDoubleToBoolean.this.stringFunction.apply(this.argA.toString());
        }

        @Override
        public NodeFuncBase getFunction() {
            return NodeFuncDoubleToBoolean.this;
        }

        public int hashCode() {
            return Objects.hash(this.argA);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FuncDoubleToBoolean other = (FuncDoubleToBoolean)obj;
            return Objects.equals(this.argA, other.argA);
        }
    }
}

