/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IDependancyVisitor;
import buildcraft.lib.expression.api.IDependantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionQuad;
import buildcraft.lib.expression.node.value.NodeConstantObject;
import java.util.Objects;

public class NodeFuncObjectObjectBooleanToObject<A, B, R>
extends NodeFuncBase
implements INodeFunc.INodeFuncObject<R> {
    public final IFuncObjectObjectBooleanToObject<A, B, R> function;
    private final StringFunctionQuad stringFunction;
    private final Class<A> argTypeA;
    private final Class<B> argTypeB;
    private final Class<R> returnType;

    public NodeFuncObjectObjectBooleanToObject(String name, Class<A> argTypeA, Class<B> argTypeB, Class<R> returnType, IFuncObjectObjectBooleanToObject<A, B, R> function) {
        this(argTypeA, argTypeB, returnType, function, (String a, String b, String c) -> "[ " + NodeTypes.getName(argTypeA) + ", " + NodeTypes.getName(argTypeB) + ", boolean -> " + NodeTypes.getName(returnType) + " ] " + name + "(" + a + ", " + b + ", " + c + ")");
    }

    public NodeFuncObjectObjectBooleanToObject(Class<A> argTypeA, Class<B> argTypeB, Class<R> returnType, IFuncObjectObjectBooleanToObject<A, B, R> function, StringFunctionQuad stringFunction) {
        this.argTypeA = argTypeA;
        this.argTypeB = argTypeB;
        this.returnType = returnType;
        this.function = function;
        this.stringFunction = stringFunction;
    }

    @Override
    public Class<R> getType() {
        return this.returnType;
    }

    public String toString() {
        return this.stringFunction.apply("{A}", "{B}", "{C}");
    }

    @Override
    public NodeFuncObjectObjectBooleanToObject<A, B, R> setNeverInline() {
        super.setNeverInline();
        return this;
    }

    @Override
    public IExpressionNode.INodeObject<R> getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeBoolean c = stack.popBoolean();
        IExpressionNode.INodeObject<B> b = stack.popObject(this.argTypeB);
        IExpressionNode.INodeObject<A> a = stack.popObject(this.argTypeA);
        return this.create(a, b, c);
    }

    public FuncObjectObjectBooleanToObject create(IExpressionNode.INodeObject<A> argA, IExpressionNode.INodeObject<B> argB, IExpressionNode.INodeBoolean argC) {
        return new FuncObjectObjectBooleanToObject(argA, argB, argC);
    }

    @FunctionalInterface
    public static interface IFuncObjectObjectBooleanToObject<A, B, R> {
        public R apply(A var1, B var2, boolean var3);
    }

    public class FuncObjectObjectBooleanToObject
    implements IExpressionNode.INodeObject<R>,
    IDependantNode,
    NodeFuncBase.IFunctionNode {
        public final IExpressionNode.INodeObject<A> argA;
        public final IExpressionNode.INodeObject<B> argB;
        public final IExpressionNode.INodeBoolean argC;

        public FuncObjectObjectBooleanToObject(IExpressionNode.INodeObject<A> argA, IExpressionNode.INodeObject<B> argB, IExpressionNode.INodeBoolean argC) {
            this.argA = argA;
            this.argB = argB;
            this.argC = argC;
        }

        @Override
        public Class<R> getType() {
            return NodeFuncObjectObjectBooleanToObject.this.returnType;
        }

        @Override
        public R evaluate() {
            return NodeFuncObjectObjectBooleanToObject.this.function.apply(this.argA.evaluate(), this.argB.evaluate(), this.argC.evaluate());
        }

        @Override
        public IExpressionNode.INodeObject<R> inline() {
            if (!NodeFuncObjectObjectBooleanToObject.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, this.argB, this.argC, (a, b, c) -> new FuncObjectObjectBooleanToObject(a, b, (IExpressionNode.INodeBoolean)c), (a, b, c) -> new FuncObjectObjectBooleanToObject(a, b, (IExpressionNode.INodeBoolean)c));
            }
            return NodeInliningHelper.tryInline(this, this.argA, this.argB, this.argC, (a, b, c) -> new FuncObjectObjectBooleanToObject(a, b, (IExpressionNode.INodeBoolean)c), (a, b, c) -> new NodeConstantObject(NodeFuncObjectObjectBooleanToObject.this.returnType, NodeFuncObjectObjectBooleanToObject.this.function.apply(a.evaluate(), b.evaluate(), c.evaluate())));
        }

        @Override
        public void visitDependants(IDependancyVisitor visitor) {
            if (!NodeFuncObjectObjectBooleanToObject.this.canInline) {
                if (NodeFuncObjectObjectBooleanToObject.this.function instanceof IDependantNode) {
                    visitor.dependOn((IDependantNode)((Object)NodeFuncObjectObjectBooleanToObject.this.function));
                } else {
                    visitor.dependOnExplictly(this);
                }
            }
            visitor.dependOn(this.argA, this.argB, this.argC);
        }

        public String toString() {
            return NodeFuncObjectObjectBooleanToObject.this.stringFunction.apply(this.argA.toString(), this.argB.toString(), this.argC.toString());
        }

        @Override
        public NodeFuncBase getFunction() {
            return NodeFuncObjectObjectBooleanToObject.this;
        }

        public int hashCode() {
            return Objects.hash(this.argA, this.argB, this.argC);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FuncObjectObjectBooleanToObject other = (FuncObjectObjectBooleanToObject)obj;
            return Objects.equals(this.argA, other.argA) && Objects.equals(this.argB, other.argB) && Objects.equals(this.argC, other.argC);
        }
    }
}

