/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui;

import buildcraft.api.core.render.ISprite;
import buildcraft.lib.gui.BuildCraftGui;
import buildcraft.lib.gui.ContainerBC_Neptune;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.json.BuildCraftJsonGui;
import buildcraft.lib.gui.json.InventorySlotHolder;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.misc.GuiUtil;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public abstract class GuiBC8<C extends ContainerBC_Neptune>
extends GuiContainer {
    public final BuildCraftGui mainGui;
    public final C container;

    public GuiBC8(C container) {
        this(container, (GuiBC8<?> g) -> new BuildCraftGui((GuiScreen)g, BuildCraftGui.createWindowedArea(g)));
    }

    public GuiBC8(C container, Function<GuiBC8<?>, BuildCraftGui> constructor) {
        super(container);
        this.container = container;
        this.mainGui = constructor.apply(this);
        this.standardLedgerInit();
    }

    public GuiBC8(C container, ResourceLocation jsonGuiDef) {
        super(container);
        this.container = container;
        BuildCraftJsonGui jsonGui = new BuildCraftJsonGui((GuiScreen)this, BuildCraftGui.createWindowedArea(this), jsonGuiDef);
        jsonGui.properties.put("player.inventory", new InventorySlotHolder((Container)container, (IInventory)((ContainerBC_Neptune)((Object)container)).player.field_71071_by));
        this.mainGui = jsonGui;
        this.standardLedgerInit();
        this.field_146999_f = 10;
        this.field_147000_g = 10;
    }

    private final void standardLedgerInit() {
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.mainGui.currentMenu == null || !this.mainGui.currentMenu.shouldFullyOverride()) {
            this.func_191948_b(mouseX, mouseY);
        }
    }

    protected boolean shouldAddHelpLedger() {
        return true;
    }

    public void drawGradientRect(IGuiArea area, int startColor, int endColor) {
        int left = (int)area.getX();
        int right = (int)area.getEndX();
        int top = (int)area.getY();
        int bottom = (int)area.getEndY();
        this.func_73733_a(left, top, right, bottom, startColor, endColor);
    }

    public void func_73733_a(int left, int top, int right, int bottom, int startColor, int endColor) {
        super.func_73733_a(left, top, right, bottom, startColor, endColor);
    }

    public List<GuiButton> getButtonList() {
        return this.field_146292_n;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void drawTexturedModalRect(double posX, double posY, double textureX, double textureY, double width, double height) {
        int x = MathHelper.func_76128_c((double)posX);
        int y = MathHelper.func_76128_c((double)posY);
        int u = MathHelper.func_76128_c((double)textureX);
        int v = MathHelper.func_76128_c((double)textureY);
        int w = MathHelper.func_76128_c((double)width);
        int h = MathHelper.func_76128_c((double)height);
        this.func_73729_b(x, y, u, v, w, h);
    }

    public void drawString(FontRenderer fontRenderer, String text, double x, double y, int colour) {
        this.drawString(fontRenderer, text, x, y, colour, true);
    }

    public void drawString(FontRenderer fontRenderer, String text, double x, double y, int colour, boolean shadow) {
        fontRenderer.func_175065_a(text, (float)x, (float)y, colour, shadow);
    }

    @Deprecated
    public static void drawItemStackAt(ItemStack stack, int x, int y) {
        GuiUtil.drawItemStackAt(stack, x, y);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.mainGui.tick();
    }

    protected final void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.mainGui.drawBackgroundLayer(partialTicks, mouseX, mouseY, () -> ((GuiBC8)this).func_146276_q_());
        this.drawBackgroundLayer(partialTicks);
        this.mainGui.drawElementBackgrounds();
    }

    protected final void func_146979_b(int mouseX, int mouseY) {
        this.mainGui.preDrawForeground();
        this.drawForegroundLayer();
        this.mainGui.drawElementForegrounds(() -> ((GuiBC8)this).func_146276_q_());
        this.drawForegroundLayerAboveElements();
        this.mainGui.postDrawForeground();
    }

    public void drawProgress(GuiRectangle rect, GuiIcon icon, double widthPercent, double heightPercent) {
        double nWidth = rect.width * Math.abs(widthPercent);
        double nHeight = rect.height * Math.abs(heightPercent);
        ISprite sprite = GuiUtil.subRelative(icon.sprite, 0.0, 0.0, widthPercent, heightPercent);
        double x = rect.x + this.mainGui.rootElement.getX();
        double y = rect.y + this.mainGui.rootElement.getY();
        GuiIcon.draw(sprite, x, y, x + nWidth, y + nHeight);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.mainGui.onMouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.mainGui.onMouseDragged(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.mainGui.onMouseReleased(mouseX, mouseY, state);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.mainGui.onKeyTyped(typedChar, keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void drawBackgroundLayer(float partialTicks) {
    }

    protected void drawForegroundLayer() {
    }

    protected void drawForegroundLayerAboveElements() {
    }
}

