/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import buildcraft.api.mj.MjAPI;
import buildcraft.lib.BCLibConfig;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IllegalFormatException;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.IFluidTank;

public class LocaleUtil {
    public static final boolean DEBUG = BCDebugging.shouldDebugLog("lib.locale");
    private static final Set<String> failedStrings = new HashSet<String>();
    private static final NumberFormat FORMAT_FLUID = NumberFormat.getNumberInstance();
    private static String localeKeyFluidStatic;
    private static String localeKeyFluidFlow;
    private static String localeKeyFluidStaticCap;
    private static String localeKeyFluidStaticEmpty;
    private static String localeKeyFluidStaticFull;
    private static String localeKeyMjStatic;
    private static String localeKeyMjFlow;
    private static String localeKeyRfStatic;
    private static String localeKeyRfFlow;

    public static void onConfigChanged() {
        boolean bucketStatic = BCLibConfig.useBucketsStatic;
        boolean bucketFlow = BCLibConfig.useBucketsFlow;
        String longName = BCLibConfig.useLongLocalizedName ? "long" : "short";
        String timeGap = BCLibConfig.displayTimeGap == BCLibConfig.TimeGap.SECONDS ? "seconds." : "";
        localeKeyFluidStatic = "buildcraft.fluid.static." + (bucketStatic ? "bucket." : "milli.") + longName;
        localeKeyFluidFlow = "buildcraft.fluid.flow." + (bucketFlow ? "bucket." : "milli.") + longName;
        localeKeyFluidStaticCap = "buildcraft.fluid.static.cap." + (bucketStatic ? "bucket." : "milli.") + longName;
        localeKeyFluidStaticEmpty = "buildcraft.fluid.empty." + (bucketFlow ? "bucket." : "milli.") + longName;
        localeKeyFluidStaticFull = "buildcraft.fluid.full." + (bucketFlow ? "bucket." : "milli.") + longName;
        localeKeyMjStatic = "buildcraft.mj.static." + longName;
        localeKeyMjFlow = "buildcraft.mj.flow." + timeGap + longName;
        localeKeyRfStatic = "buildcraft.rf.static." + longName;
        localeKeyRfFlow = "buildcraft.rf.flow." + timeGap + longName;
    }

    public static String localize(String key) {
        String localized = I18n.func_74838_a((String)key);
        if (localized == key) {
            if (DEBUG && failedStrings.add(localized)) {
                BCLog.logger.warn("[lib.locale] Attempted to localize '" + key + "' but no localization existed!");
            }
            return key;
        }
        return localized;
    }

    public static String localize(String key, Object ... args) {
        String localized = I18n.func_74838_a((String)key);
        if (localized == key) {
            if (DEBUG && failedStrings.add(localized)) {
                BCLog.logger.warn("[lib.locale] Attempted to localize '" + key + "' but no localization existed!");
            }
            return key + " " + Arrays.toString(args);
        }
        try {
            return String.format(localized, args);
        }
        catch (IllegalFormatException ife) {
            return "Bad Format: " + ife.getMessage();
        }
    }

    public static boolean canLocalize(String key) {
        return I18n.func_94522_b((String)key);
    }

    public static String localizeColour(EnumDyeColor colour) {
        return LocaleUtil.localize("item.fireworksCharge." + colour.func_176762_d());
    }

    public static String localizeFacing(@Nullable EnumFacing face) {
        return LocaleUtil.localize("direction." + (face == null ? "center" : face.func_176610_l()));
    }

    public static String localizeFluidStaticAmount(IFluidTank tank) {
        return LocaleUtil.localizeFluidStaticAmount(tank.getFluidAmount(), tank.getCapacity());
    }

    public static String localizeFluidStaticAmount(int fluidAmount) {
        return LocaleUtil.localizeFluidStaticAmount(fluidAmount, -1);
    }

    public static String localizeFluidStaticAmount(int fluidAmount, int capacity) {
        String cap;
        String amount;
        if (fluidAmount <= 0) {
            if (capacity > 0) {
                String cap2 = BCLibConfig.useBucketsStatic ? FORMAT_FLUID.format((double)capacity / 1000.0) : FORMAT_FLUID.format(capacity);
                return LocaleUtil.localize(localeKeyFluidStaticEmpty, cap2);
            }
            return LocaleUtil.localize("buildcraft.fluid.empty");
        }
        if (BCLibConfig.useBucketsStatic) {
            amount = FORMAT_FLUID.format((double)fluidAmount / 1000.0);
            cap = FORMAT_FLUID.format((double)capacity / 1000.0);
        } else {
            amount = FORMAT_FLUID.format(fluidAmount);
            cap = FORMAT_FLUID.format(capacity);
        }
        if (capacity == fluidAmount) {
            return LocaleUtil.localize(localeKeyFluidStaticFull, amount);
        }
        return LocaleUtil.localize(capacity > 0 ? localeKeyFluidStaticCap : localeKeyFluidStatic, amount, cap);
    }

    public static String localizeFluidFlow(int milliBucketsPerTick) {
        String amount = BCLibConfig.useBucketsFlow ? FORMAT_FLUID.format((double)milliBucketsPerTick / 50.0) : FORMAT_FLUID.format(milliBucketsPerTick);
        return LocaleUtil.localize(localeKeyFluidFlow, amount);
    }

    public static String localizeRfFlow(long mj) {
        String rf = MjAPI.formatRFFromMj(BCLibConfig.displayTimeGap.convertTicksToGap(mj));
        return LocaleUtil.localize(localeKeyRfFlow, rf);
    }

    public static String localizeRf2(int rf) {
        return LocaleUtil.localize(localeKeyRfFlow, MjAPI.formatRF(rf));
    }

    public static String localizeRf(long mj) {
        return LocaleUtil.localize(localeKeyRfStatic, (int)(mj * (long)MjAPI.rfPerMj / MjAPI.MJ));
    }

    public static String localizeHeat(double heat) {
        return String.format("%.2f \u00b0C", heat);
    }

    static {
        BCLibConfig.configChangeListeners.add(LocaleUtil::onConfigChanged);
        LocaleUtil.onConfigChanged();
    }
}

