/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc.data;

import buildcraft.lib.misc.MathUtil;
import buildcraft.lib.misc.NBTUtilBC;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class AverageDouble
implements INBTSerializable<NBTTagCompound> {
    private double[] data;
    private int pos;
    private int precise;
    private double averageRaw;
    private double tickValue;

    public AverageDouble(int precise) {
        this.precise = precise;
        this.data = new double[precise];
        this.pos = 0;
    }

    public double getAverage() {
        return this.averageRaw / (double)this.precise;
    }

    public void tick(double value) {
        this.internalTick(this.tickValue + value);
        this.tickValue = 0.0;
    }

    public void tick() {
        this.internalTick(this.tickValue);
        this.tickValue = 0.0;
    }

    private void internalTick(double value) {
        this.pos = (this.pos + 1) % this.precise;
        double oldValue = this.data[this.pos];
        this.data[this.pos] = value;
        if (this.pos == 0) {
            this.averageRaw = 0.0;
            for (double iValue : this.data) {
                this.averageRaw += iValue;
            }
        } else {
            this.averageRaw = this.averageRaw - oldValue + value;
        }
    }

    public void push(double value) {
        this.tickValue += value;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("pos", this.pos);
        nbt.func_74768_a("precise", this.precise);
        nbt.func_74780_a("averageRaw", this.averageRaw);
        nbt.func_74780_a("tickValue", this.tickValue);
        nbt.func_74782_a("data", NBTUtilBC.writeDoubleArray(this.data));
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.precise = MathUtil.clamp(nbt.func_74762_e("precise"), 1, Short.MAX_VALUE);
        this.pos = MathUtil.clamp(nbt.func_74762_e("pos"), 0, this.precise);
        this.averageRaw = nbt.func_74769_h("averageRaw");
        this.tickValue = nbt.func_74769_h("tickValue");
        this.data = NBTUtilBC.readDoubleArray(nbt.func_74781_a("data"), this.precise);
    }

    public String toString() {
        return String.valueOf(this.getAverage());
    }
}

