/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc.data;

import net.minecraft.nbt.NBTTagCompound;

public class AverageLong {
    private long[] data;
    private final int precise;
    private int pos;
    private long averageRaw;
    private long tickValue;

    public AverageLong(int precise) {
        this.precise = precise;
        this.clear();
    }

    public void clear() {
        this.data = new long[this.precise];
        this.pos = 0;
    }

    public double getAverage() {
        double s = 0.0;
        for (long l : this.data) {
            s += (double)l;
        }
        return s / (double)this.precise;
    }

    public long getAverageLong() {
        long s = 0L;
        for (long l : this.data) {
            s += l;
        }
        return s / (long)this.precise;
    }

    public void tick(long value) {
        this.internalTick(this.tickValue + value);
        this.tickValue = 0L;
    }

    public void tick() {
        this.internalTick(this.tickValue);
        this.tickValue = 0L;
    }

    private void internalTick(long value) {
        ++this.pos;
        this.pos %= this.precise;
        long oldValue = this.data[this.pos];
        this.data[this.pos] = value;
        if (this.pos == 0) {
            this.averageRaw = 0L;
            for (long iValue : this.data) {
                this.averageRaw += iValue;
            }
        } else {
            this.averageRaw = this.averageRaw - oldValue + value;
        }
    }

    public void push(long value) {
        this.tickValue += value;
    }

    public void writeToNbt(NBTTagCompound nbt, String subTag) {
        int[] ints = new int[this.precise * 2];
        for (int i = 0; i < this.precise; ++i) {
            long val = this.data[i];
            ints[i * 2] = (int)val;
            ints[i * 2 + 1] = (int)(val >>> 32);
        }
        nbt.func_74783_a(subTag, ints);
    }

    public void readFromNbt(NBTTagCompound nbt, String subTag) {
        int[] ints = nbt.func_74759_k(subTag);
        if (ints.length >= this.precise * 2) {
            this.averageRaw = 0L;
            this.pos = 0;
            this.tickValue = 0L;
            for (int i = 0; i < this.precise; ++i) {
                long val = ints[i * 2];
                this.averageRaw += (val |= (long)ints[i * 2 + 1] << 32);
                this.data[i] = val;
            }
        }
    }

    public String toString() {
        return String.valueOf(this.getAverage());
    }
}

