/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.nbt;

import buildcraft.api.core.InvalidInputDataException;
import buildcraft.lib.misc.data.DecompactingBitSet;
import buildcraft.lib.nbt.NbtSquishMap;
import buildcraft.lib.nbt.WrittenType;
import gnu.trove.list.array.TByteArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.io.DataInput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

class NbtSquishMapReader {
    private final NbtSquishMap map = new NbtSquishMap();

    NbtSquishMapReader() {
    }

    public static NbtSquishMap read(DataInput in) throws IOException {
        return new NbtSquishMapReader().readInternal(in);
    }

    private NbtSquishMap readInternal(DataInput in) throws IOException {
        int j;
        TByteArrayList list;
        int arraySize;
        int i;
        int count;
        WrittenType type = WrittenType.readType(in);
        int flags = in.readInt();
        if (NbtSquishMapReader.isFlag(flags, 1)) {
            count = NbtSquishMapReader.readVarInt(in);
            for (i = 0; i < count; ++i) {
                this.map.bytes.add(in.readByte());
            }
        }
        if (NbtSquishMapReader.isFlag(flags, 2)) {
            count = NbtSquishMapReader.readVarInt(in);
            for (i = 0; i < count; ++i) {
                this.map.shorts.add(in.readShort());
            }
        }
        if (NbtSquishMapReader.isFlag(flags, 4)) {
            count = NbtSquishMapReader.readVarInt(in);
            for (i = 0; i < count; ++i) {
                this.map.ints.add(in.readInt());
            }
        }
        if (NbtSquishMapReader.isFlag(flags, 8)) {
            count = NbtSquishMapReader.readVarInt(in);
            for (i = 0; i < count; ++i) {
                this.map.longs.add(in.readLong());
            }
        }
        if (NbtSquishMapReader.isFlag(flags, 16)) {
            count = NbtSquishMapReader.readVarInt(in);
            for (i = 0; i < count; ++i) {
                this.map.floats.add(in.readFloat());
            }
        }
        if (NbtSquishMapReader.isFlag(flags, 32)) {
            count = NbtSquishMapReader.readVarInt(in);
            for (i = 0; i < count; ++i) {
                this.map.doubles.add(in.readDouble());
            }
        }
        if (NbtSquishMapReader.isFlag(flags, 64)) {
            count = NbtSquishMapReader.readVarInt(in);
            for (i = 0; i < count; ++i) {
                arraySize = in.readUnsignedShort();
                list = new TByteArrayList();
                for (j = 0; j < arraySize; ++j) {
                    list.add(in.readByte());
                }
                this.map.byteArrays.add(list);
            }
        }
        if (NbtSquishMapReader.isFlag(flags, 128)) {
            count = NbtSquishMapReader.readVarInt(in);
            for (i = 0; i < count; ++i) {
                arraySize = in.readUnsignedShort();
                list = new TIntArrayList();
                for (j = 0; j < arraySize; ++j) {
                    list.add(in.readInt());
                }
                this.map.intArrays.add((TIntArrayList)list);
            }
        }
        if (NbtSquishMapReader.isFlag(flags, 256)) {
            count = NbtSquishMapReader.readVarInt(in);
            for (i = 0; i < count; ++i) {
                int length = in.readUnsignedShort();
                byte[] bytes = new byte[length];
                in.readFully(bytes);
                this.map.strings.add(new String(bytes, StandardCharsets.UTF_8));
            }
        }
        if (NbtSquishMapReader.isFlag(flags, 512)) {
            count = NbtSquishMapReader.readVarInt(in);
            for (i = 0; i < count; ++i) {
                int complexType = in.readUnsignedByte();
                if (complexType == 0) {
                    this.map.complex.add((NBTBase)this.readCompound(type, in));
                    continue;
                }
                if (complexType == 1) {
                    this.map.complex.add((NBTBase)this.readNormalList(type, in));
                    continue;
                }
                if (complexType == 2) {
                    this.map.complex.add((NBTBase)this.readPackedList(type, in));
                    continue;
                }
                throw new IOException("Unknown complex type " + complexType);
            }
        }
        return this.map;
    }

    private static int readVarInt(DataInput in) throws IOException {
        int b;
        int value = 0;
        int bytesRead = 0;
        do {
            b = in.readUnsignedByte();
            value |= (b & 0x7F) << bytesRead * 7;
            if (++bytesRead <= 5) continue;
            throw new InvalidInputDataException("VarInt can only be up to 5 bytes long!");
        } while ((b & 0x80) != 0);
        return value;
    }

    private static boolean isFlag(int flags, int flag) {
        return (flags & flag) == flag;
    }

    private NBTTagCompound readCompound(WrittenType type, DataInput in) throws IOException {
        WrittenType stringType = WrittenType.getForSize(this.map.stringSize());
        int count = NbtSquishMapReader.readVarInt(in);
        NBTTagCompound nbt = new NBTTagCompound();
        for (int i = 0; i < count; ++i) {
            String key = this.map.getStringForReading(stringType.readIndex(in));
            NBTBase value = this.map.getTagForReading(type.readIndex(in));
            nbt.func_74782_a(key, value.func_74737_b());
        }
        return nbt;
    }

    private NBTTagList readNormalList(WrittenType type, DataInput in) throws IOException {
        int count = NbtSquishMapReader.readVarInt(in);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < count; ++i) {
            int index = type.readIndex(in);
            list.func_74742_a(this.map.getTagForReading(index));
        }
        return list;
    }

    private NBTTagList readPackedList(WrittenType type, DataInput in) throws IOException {
        int count = NbtSquishMapReader.readVarInt(in);
        ArrayList<NBTBase> dictionary = new ArrayList<NBTBase>();
        for (int i = 0; i < count; ++i) {
            int index = type.readIndex(in);
            NBTBase nbt = this.map.getTagForReading(index);
            dictionary.add(nbt);
        }
        ArrayList list = new ArrayList();
        TIntArrayList left = new TIntArrayList();
        int bits = 1;
        int entries = NbtSquishMapReader.readVarInt(in);
        for (int i = 0; i < entries; ++i) {
            list.add(null);
            left.add(i);
        }
        while (!dictionary.isEmpty()) {
            int bitsetSize = NbtSquishMapReader.readVarInt(in);
            byte[] bitsetData = new byte[bitsetSize];
            in.readFully(bitsetData);
            DecompactingBitSet decompactor = new DecompactingBitSet(bits, bitsetData);
            TIntArrayList nextLeft = new TIntArrayList();
            int maxVal = (1 << bits) - 1;
            for (int i : left.toArray()) {
                int index = decompactor.next();
                if (index < maxVal) {
                    list.set(i, dictionary.get(index));
                    continue;
                }
                nextLeft.add(i);
            }
            dictionary.subList(0, Math.min(dictionary.size(), maxVal)).clear();
            left = nextLeft;
            ++bits;
        }
        NBTTagList tag = new NBTTagList();
        for (NBTBase base : list) {
            tag.func_74742_a(base);
        }
        return tag;
    }
}

