/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.recipe;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.recipes.IngredientStack;
import buildcraft.api.recipes.IntegrationRecipe;
import buildcraft.lib.misc.StackUtil;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class IntegrationRecipeBasic
extends IntegrationRecipe {
    protected final long requiredMicroJoules;
    protected final IngredientStack target;
    protected final ImmutableList<IngredientStack> toIntegrate;
    @Nonnull
    protected final ItemStack output;

    public IntegrationRecipeBasic(ResourceLocation name, long requiredMicroJoules, IngredientStack target, List<IngredientStack> toIntegrate, @Nonnull ItemStack output) {
        super(name);
        this.requiredMicroJoules = requiredMicroJoules;
        this.target = target;
        this.toIntegrate = ImmutableList.copyOf(toIntegrate);
        this.output = output;
    }

    public IntegrationRecipeBasic(String name, long requiredMicroJoules, IngredientStack target, List<IngredientStack> toIntegrate, @Nonnull ItemStack output) {
        this(BuildCraftAPI.nameToResourceLocation(name), requiredMicroJoules, target, toIntegrate, output);
    }

    protected boolean matches(@Nonnull ItemStack target, NonNullList<ItemStack> toIntegrate) {
        if (!StackUtil.contains(this.target, target)) {
            return false;
        }
        NonNullList toIntegrateCopy = toIntegrate.stream().filter(stack -> !stack.func_190926_b()).collect(StackUtil.nonNullListCollector());
        boolean stackMatches = this.toIntegrate.stream().allMatch(definition -> {
            boolean matches = false;
            Iterator iterator = toIntegrateCopy.iterator();
            while (iterator.hasNext()) {
                ItemStack stack = (ItemStack)iterator.next();
                if (!StackUtil.contains(definition, stack)) continue;
                matches = true;
                iterator.remove();
                break;
            }
            return matches;
        });
        return stackMatches && toIntegrateCopy.isEmpty();
    }

    @Override
    public ItemStack getOutput(@Nonnull ItemStack target, NonNullList<ItemStack> toIntegrate) {
        return this.matches(target, toIntegrate) ? this.output : ItemStack.field_190927_a;
    }

    @Override
    public ImmutableList<IngredientStack> getRequirements(ItemStack output) {
        return this.toIntegrate;
    }

    @Override
    public long getRequiredMicroJoules() {
        return this.requiredMicroJoules;
    }

    @Override
    public IngredientStack getCenterStack() {
        return this.target;
    }

    @Override
    public List<IngredientStack> getSurrounding() {
        return this.toIntegrate;
    }

    @Override
    public ItemStack getOutput() {
        return this.output;
    }
}

