/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.recipe;

import buildcraft.api.recipes.IRefineryRecipeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;

public enum RefineryRecipeRegistry implements IRefineryRecipeManager
{
    INSTANCE;

    public final IRefineryRecipeManager.IRefineryRegistry<IRefineryRecipeManager.IDistillationRecipe> distillationRegistry = new SingleRegistry<IRefineryRecipeManager.IDistillationRecipe>();

    @Override
    public IRefineryRecipeManager.IDistillationRecipe createDistillationRecipe(FluidStack in, FluidStack outLiquid, long powerRequired) {
        return new DistillationRecipe(powerRequired, in, outLiquid);
    }

    @Override
    public IRefineryRecipeManager.IRefineryRegistry<IRefineryRecipeManager.IDistillationRecipe> getDistillationRegistry() {
        return this.distillationRegistry;
    }

    public static class DistillationRecipe
    extends RefineryRecipe
    implements IRefineryRecipeManager.IDistillationRecipe {
        private final FluidStack outLiquid;
        private final long powerRequired;

        public DistillationRecipe(long powerRequired, FluidStack in, FluidStack outLiquid) {
            super(in);
            this.powerRequired = powerRequired;
            this.outLiquid = outLiquid;
        }

        @Override
        public FluidStack outLiquid() {
            return this.outLiquid;
        }

        @Override
        public long powerRequired() {
            return this.powerRequired;
        }
    }

    public static abstract class RefineryRecipe
    implements IRefineryRecipeManager.IRefineryRecipe {
        private final FluidStack in;

        public RefineryRecipe(FluidStack in) {
            this.in = in;
        }

        @Override
        public FluidStack in() {
            return this.in;
        }
    }

    private static class SingleRegistry<R extends IRefineryRecipeManager.IRefineryRecipe>
    implements IRefineryRecipeManager.IRefineryRegistry<R> {
        private final List<R> allRecipes = new LinkedList<R>();

        private SingleRegistry() {
        }

        @Override
        public Stream<R> getRecipes(Predicate<R> filter) {
            return this.allRecipes.stream().filter(filter);
        }

        @Override
        public Collection<R> getAllRecipes() {
            return this.allRecipes;
        }

        @Override
        @Nullable
        public R getRecipeForInput(@Nullable FluidStack fluid) {
            if (fluid == null) {
                return null;
            }
            for (IRefineryRecipeManager.IRefineryRecipe recipe : this.allRecipes) {
                if (!recipe.in().isFluidEqual(fluid)) continue;
                return (R)recipe;
            }
            return null;
        }

        @Override
        public Collection<R> removeRecipes(Predicate<R> toRemove) {
            ArrayList<IRefineryRecipeManager.IRefineryRecipe> removed = new ArrayList<IRefineryRecipeManager.IRefineryRecipe>();
            Iterator<R> iter = this.allRecipes.iterator();
            while (iter.hasNext()) {
                IRefineryRecipeManager.IRefineryRecipe recipe = (IRefineryRecipeManager.IRefineryRecipe)iter.next();
                if (!toRemove.test(recipe)) continue;
                iter.remove();
                removed.add(recipe);
            }
            return removed;
        }

        @Override
        public R addRecipe(R recipe) {
            if (recipe == null) {
                throw new NullPointerException("recipe");
            }
            ListIterator<R> iter = this.allRecipes.listIterator();
            while (iter.hasNext()) {
                IRefineryRecipeManager.IRefineryRecipe existing = (IRefineryRecipeManager.IRefineryRecipe)iter.next();
                if (!existing.in().isFluidEqual(recipe.in())) continue;
                iter.set(recipe);
                return recipe;
            }
            this.allRecipes.add(recipe);
            return recipe;
        }
    }
}

