/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.core.BCLog;
import buildcraft.api.enums.EnumEngineType;
import buildcraft.api.enums.EnumRedstoneChipset;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.recipes.AssemblyRecipeBasic;
import buildcraft.api.recipes.IngredientStack;
import buildcraft.core.BCCoreBlocks;
import buildcraft.core.BCCoreConfig;
import buildcraft.core.BCCoreItems;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.lib.recipe.AssemblyRecipeRegistry;
import buildcraft.silicon.BCSiliconItems;
import buildcraft.silicon.gate.EnumGateLogic;
import buildcraft.silicon.gate.EnumGateMaterial;
import buildcraft.silicon.gate.GateVariant;
import buildcraft.silicon.recipe.FacadeAssemblyRecipes;
import buildcraft.silicon.recipe.FacadeSwapRecipe;
import buildcraft.transport.BCTransportItems;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="buildcraftsilicon")
public class BCSiliconRecipes {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (BCSiliconItems.plugGate != null) {
            ImmutableSet.Builder input;
            ImmutableSet input2;
            ItemStack output;
            if (BCSiliconItems.plugPulsar != null) {
                output = new ItemStack((Item)BCSiliconItems.plugPulsar);
                ItemStack redstoneEngine = BCCoreBlocks.engine != null ? BCCoreBlocks.engine.getStack(EnumEngineType.WOOD) : new ItemStack(Blocks.field_150451_bX);
                HashSet<IngredientStack> input3 = new HashSet<IngredientStack>();
                input3.add(new IngredientStack(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{redstoneEngine})));
                input3.add(new IngredientStack(CraftingHelper.getIngredient((Object)"ingotIron"), 2));
                AssemblyRecipeBasic recipe = new AssemblyRecipeBasic("plug_pulsar", 1000L * MjAPI.MJ, input3, output);
                AssemblyRecipeRegistry.register(recipe);
            }
            if (BCSiliconItems.plugGate != null) {
                output = new ItemStack((Item)BCSiliconItems.plugGate);
                input2 = ImmutableSet.of((Object)IngredientStack.of(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)BCSiliconItems.redstoneChipset)})));
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic("gate_basic", 1000L * MjAPI.MJ, (ImmutableSet<IngredientStack>)input2, output));
                input2 = ImmutableSet.of((Object)IngredientStack.of(new ItemStack((Item)BCSiliconItems.redstoneChipset, 1, 1)), (Object)IngredientStack.of(new ItemStack((Item)BCTransportItems.wire, 1, 14)));
                output = BCSiliconItems.plugGate.getStack(new GateVariant(EnumGateLogic.OR, EnumGateMaterial.IRON));
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic("gate_iron_or", 2000L * MjAPI.MJ, (ImmutableSet<IngredientStack>)input2, output));
                output = BCSiliconItems.plugGate.getStack(new GateVariant(EnumGateLogic.AND, EnumGateMaterial.IRON));
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic("gate_iron_and", 2000L * MjAPI.MJ, (ImmutableSet<IngredientStack>)input2, output));
                input2 = ImmutableSet.of((Object)IngredientStack.of(new ItemStack((Item)BCSiliconItems.redstoneChipset, 1, 2)), (Object)IngredientStack.of(new ItemStack((Item)BCTransportItems.wire, 1, 14)), (Object)IngredientStack.of(new ItemStack((Item)BCTransportItems.wire, 1, 13)));
                output = BCSiliconItems.plugGate.getStack(new GateVariant(EnumGateLogic.OR, EnumGateMaterial.GOLD));
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic("gate_gold_or", 4000L * MjAPI.MJ, (ImmutableSet<IngredientStack>)input2, output));
                output = BCSiliconItems.plugGate.getStack(new GateVariant(EnumGateLogic.AND, EnumGateMaterial.GOLD));
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic("gate_gold_and", 4000L * MjAPI.MJ, (ImmutableSet<IngredientStack>)input2, output));
                input2 = ImmutableSet.of((Object)IngredientStack.of(new ItemStack((Item)BCSiliconItems.redstoneChipset, 1, 3)), (Object)IngredientStack.of(new ItemStack((Item)BCTransportItems.wire, 1, 14)), (Object)IngredientStack.of(new ItemStack((Item)BCTransportItems.wire, 1, 13)), (Object)IngredientStack.of(new ItemStack((Item)BCTransportItems.wire, 1, 11)));
                output = BCSiliconItems.plugGate.getStack(new GateVariant(EnumGateLogic.OR, EnumGateMaterial.QUARTZ));
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic("gate_quartz_or", 8000L * MjAPI.MJ, (ImmutableSet<IngredientStack>)input2, output));
                output = BCSiliconItems.plugGate.getStack(new GateVariant(EnumGateLogic.AND, EnumGateMaterial.QUARTZ));
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic("gate_quartz_and", 8000L * MjAPI.MJ, (ImmutableSet<IngredientStack>)input2, output));
                input2 = ImmutableSet.of((Object)IngredientStack.of(new ItemStack((Item)BCSiliconItems.redstoneChipset, 1, 4)), (Object)IngredientStack.of(new ItemStack((Item)BCTransportItems.wire, 1, 14)), (Object)IngredientStack.of(new ItemStack((Item)BCTransportItems.wire, 1, 13)), (Object)IngredientStack.of(new ItemStack((Item)BCTransportItems.wire, 1, 11)), (Object)IngredientStack.of(new ItemStack((Item)BCTransportItems.wire, 1, 0)));
                output = BCSiliconItems.plugGate.getStack(new GateVariant(EnumGateLogic.OR, EnumGateMaterial.DIAMOND));
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic("gate_diamond_or", 16000L * MjAPI.MJ, (ImmutableSet<IngredientStack>)input2, output));
                output = BCSiliconItems.plugGate.getStack(new GateVariant(EnumGateLogic.AND, EnumGateMaterial.DIAMOND));
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic("gate_diamond_and", 16000L * MjAPI.MJ, (ImmutableSet<IngredientStack>)input2, output));
                input2 = ImmutableSet.of((Object)IngredientStack.of(new ItemStack((Item)BCSiliconItems.redstoneChipset, 1, 5)), (Object)IngredientStack.of(new ItemStack((Item)BCTransportItems.wire, 1, 14)), (Object)IngredientStack.of(new ItemStack((Item)BCTransportItems.wire, 1, 13)), (Object)IngredientStack.of(new ItemStack((Item)BCTransportItems.wire, 1, 11)), (Object)IngredientStack.of(new ItemStack((Item)BCTransportItems.wire, 1, 0)), (Object)IngredientStack.of(new ItemStack((Item)BCTransportItems.wire, 1, 4)), (Object[])new IngredientStack[0]);
                output = BCSiliconItems.plugGate.getStack(new GateVariant(EnumGateLogic.OR, EnumGateMaterial.EMERALD));
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic("gate_emerald_or", 32000L * MjAPI.MJ, (ImmutableSet<IngredientStack>)input2, output));
                output = BCSiliconItems.plugGate.getStack(new GateVariant(EnumGateLogic.AND, EnumGateMaterial.EMERALD));
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic("gate_emerald_and", 32000L * MjAPI.MJ, (ImmutableSet<IngredientStack>)input2, output));
            }
            if (BCSiliconItems.plugLightSensor != null) {
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic("light-sensor", 500L * MjAPI.MJ, (ImmutableSet<IngredientStack>)ImmutableSet.of((Object)IngredientStack.of(Blocks.field_150453_bW)), new ItemStack((Item)BCSiliconItems.plugLightSensor)));
            }
            if (BCSiliconItems.plugFacade != null) {
                AssemblyRecipeRegistry.register(FacadeAssemblyRecipes.INSTANCE);
                ForgeRegistries.RECIPES.register((IForgeRegistryEntry)FacadeSwapRecipe.INSTANCE);
            }
            if (BCSiliconItems.plugLens != null) {
                for (EnumDyeColor colour : ColourUtil.COLOURS) {
                    String name = String.format("lens-regular-%s", colour.func_176762_d());
                    IngredientStack stainedGlass = IngredientStack.of("blockGlass" + ColourUtil.getName(colour));
                    ImmutableSet input4 = ImmutableSet.of((Object)stainedGlass);
                    ItemStack output2 = BCSiliconItems.plugLens.getStack(colour, false);
                    AssemblyRecipeRegistry.register(new AssemblyRecipeBasic(name, 500L * MjAPI.MJ, (ImmutableSet<IngredientStack>)input4, output2));
                    name = String.format("lens-filter-%s", colour.func_176762_d());
                    output2 = BCSiliconItems.plugLens.getStack(colour, true);
                    input4 = ImmutableSet.of((Object)stainedGlass, (Object)IngredientStack.of(new ItemStack(Blocks.field_150411_aY)));
                    AssemblyRecipeRegistry.register(new AssemblyRecipeBasic(name, 500L * MjAPI.MJ, (ImmutableSet<IngredientStack>)input4, output2));
                }
                IngredientStack glass = IngredientStack.of("blockGlass");
                input2 = ImmutableSet.of((Object)glass);
                ItemStack output3 = BCSiliconItems.plugLens.getStack(null, false);
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic("lens-regular", 500L * MjAPI.MJ, (ImmutableSet<IngredientStack>)input2, output3));
                output3 = BCSiliconItems.plugLens.getStack(null, true);
                input2 = ImmutableSet.of((Object)glass, (Object)IngredientStack.of(new ItemStack(Blocks.field_150411_aY)));
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic("lens-filter", 500L * MjAPI.MJ, (ImmutableSet<IngredientStack>)input2, output3));
            }
            if (BCSiliconItems.plugFader != null) {
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic("fader", 1000L * MjAPI.MJ, (ImmutableSet<IngredientStack>)ImmutableSet.of((Object)IngredientStack.of(Items.field_151132_bS), (Object)new IngredientStack(CraftingHelper.getIngredient((Object)Items.field_151042_j), 2)), new ItemStack((Item)BCSiliconItems.plugFader)));
            }
            if (BCSiliconItems.plugTimer != null) {
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic("timer", 1000L * MjAPI.MJ, (ImmutableSet<IngredientStack>)ImmutableSet.of((Object)IngredientStack.of(Items.field_151107_aW), (Object)new IngredientStack(CraftingHelper.getIngredient((Object)Items.field_151042_j), 2)), new ItemStack((Item)BCSiliconItems.plugTimer)));
            }
            if (BCSiliconItems.gateCopier != null) {
                input = ImmutableSet.builder();
                if (BCCoreItems.wrench != null) {
                    input.add((Object)IngredientStack.of(BCCoreItems.wrench));
                } else {
                    input.add((Object)IngredientStack.of(Items.field_151055_y));
                    input.add((Object)IngredientStack.of(Items.field_151042_j));
                }
                if (BCSiliconItems.redstoneChipset != null) {
                    input.add((Object)IngredientStack.of(EnumRedstoneChipset.IRON.getStack(1)));
                } else {
                    input.add((Object)IngredientStack.of("dustRedstone"));
                    input.add((Object)IngredientStack.of("dustRedstone"));
                    input.add((Object)IngredientStack.of("ingotGold"));
                }
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic("gate_copier", 500L * MjAPI.MJ, (ImmutableSet<IngredientStack>)input.build(), new ItemStack((Item)BCSiliconItems.gateCopier)));
            }
            if (BCSiliconItems.redstoneChipset != null) {
                input = ImmutableSet.of((Object)IngredientStack.of("dustRedstone"));
                ItemStack output4 = EnumRedstoneChipset.RED.getStack(1);
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic("redstone_chipset", 10000L * MjAPI.MJ, (ImmutableSet<IngredientStack>)input, output4));
                input = ImmutableSet.of((Object)IngredientStack.of("dustRedstone"), (Object)IngredientStack.of("ingotIron"));
                output4 = EnumRedstoneChipset.IRON.getStack(1);
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic("iron_chipset", 20000L * MjAPI.MJ, (ImmutableSet<IngredientStack>)input, output4));
                input = ImmutableSet.of((Object)IngredientStack.of("dustRedstone"), (Object)IngredientStack.of("ingotGold"));
                output4 = EnumRedstoneChipset.GOLD.getStack(1);
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic("gold_chipset", 40000L * MjAPI.MJ, (ImmutableSet<IngredientStack>)input, output4));
                input = ImmutableSet.of((Object)IngredientStack.of("dustRedstone"), (Object)IngredientStack.of("gemQuartz"));
                output4 = EnumRedstoneChipset.QUARTZ.getStack(1);
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic("quartz_chipset", 60000L * MjAPI.MJ, (ImmutableSet<IngredientStack>)input, output4));
                input = ImmutableSet.of((Object)IngredientStack.of("dustRedstone"), (Object)IngredientStack.of("gemDiamond"));
                output4 = EnumRedstoneChipset.DIAMOND.getStack(1);
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic("diamond_chipset", 80000L * MjAPI.MJ, (ImmutableSet<IngredientStack>)input, output4));
                input = ImmutableSet.of((Object)IngredientStack.of("dustRedstone"), (Object)IngredientStack.of("gemEmerald"));
                output4 = EnumRedstoneChipset.EMERALD.getStack(1);
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic("emerald_chipset", 100000L * MjAPI.MJ, (ImmutableSet<IngredientStack>)input, output4));
            }
            BCSiliconRecipes.scanForJsonRecipes();
        }
    }

    private static void scanForJsonRecipes() {
        final boolean[] failed = new boolean[]{false};
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            JsonContext ctx = new JsonContext(mod.getModId());
            CraftingHelper.findFiles((ModContainer)mod, (String)("assets/" + mod.getModId() + "/assembly_recipes_pre_mj"), null, (root, file) -> {
                try {
                    BCSiliconRecipes.readAndAddJsonRecipe(ctx, root, file);
                    return true;
                }
                catch (IOException io) {
                    BCLog.logger.error("Couldn't read recipe " + root.relativize((Path)file) + " from " + file, (Throwable)io);
                    failed[0] = true;
                    return true;
                }
            }, (boolean)false, (boolean)false);
        }
        final Path configRoot = BCCoreConfig.configFolder.toPath().resolve("assembly_recipes_pre_mj");
        if (!Files.isDirectory(configRoot, new LinkOption[0])) {
            try {
                Files.createDirectory(configRoot, new FileAttribute[0]);
            }
            catch (IOException e) {
                BCLog.logger.warn("[silicon.assembly] Unable to create the folder " + configRoot);
                failed[0] = true;
                return;
            }
        }
        try {
            final JsonContext ctx = new JsonContext("_config");
            Files.walkFileTree(configRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        BCSiliconRecipes.readAndAddJsonRecipe(ctx, configRoot, file);
                    }
                    catch (JsonParseException e) {
                        e.printStackTrace();
                        failed[0] = true;
                    }
                    catch (IOException io) {
                        io.printStackTrace();
                        failed[0] = true;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            BCLog.logger.warn("[silicon.assembly] Failed to walk the config folder " + configRoot, (Throwable)e);
            failed[0] = false;
        }
        if (failed[0]) {
            throw new IllegalStateException("Failed to read some assembly recipe files! Check the log for details");
        }
    }

    private static void readAndAddJsonRecipe(JsonContext ctx, Path root, Path file) throws JsonParseException, IOException {
        if (!file.toString().endsWith(".json")) {
            return;
        }
        String name = root.relativize(file).toString().replace("\\", "/");
        ResourceLocation key = new ResourceLocation(ctx.getModId(), name);
        try (BufferedReader reader = Files.newBufferedReader(file);){
            JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
            if (json == null || json.isJsonNull()) {
                throw new JsonSyntaxException("Json is null (empty file?)");
            }
            ItemStack output = CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject("result"), (JsonContext)ctx);
            long powercost = json.get("MJ").getAsLong() * MjAPI.MJ;
            ArrayList ingredients = new ArrayList();
            json.getAsJsonArray("components").forEach(element -> {
                JsonObject object = element.getAsJsonObject();
                ingredients.add(new IngredientStack(CraftingHelper.getIngredient((JsonElement)object.get("ingredient"), (JsonContext)ctx), JsonUtils.func_151208_a((JsonObject)object, (String)"amount", (int)1)));
            });
            AssemblyRecipeRegistry.REGISTRY.put(key, new AssemblyRecipeBasic(key, powercost, (ImmutableSet<IngredientStack>)ImmutableSet.copyOf(ingredients), output));
        }
    }
}

