/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gui;

import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.button.IButtonBehaviour;
import buildcraft.lib.gui.json.BuildCraftJsonGui;
import buildcraft.lib.misc.collect.TypedKeyMap;
import buildcraft.silicon.container.ContainerGate;
import buildcraft.silicon.gate.GateLogic;
import net.minecraft.util.ResourceLocation;

public class GuiGate
extends GuiBC8<ContainerGate> {
    public static final ResourceLocation GUI_DEFINITION = new ResourceLocation("buildcraftsilicon:gui/gate.json");

    public GuiGate(ContainerGate container) {
        super(container, GUI_DEFINITION);
        BuildCraftJsonGui jsonGui = (BuildCraftJsonGui)this.mainGui;
        this.preLoad(jsonGui);
        jsonGui.load();
        this.field_146999_f = jsonGui.getSizeX();
        this.field_147000_g = jsonGui.getSizeY();
    }

    protected void preLoad(BuildCraftJsonGui json) {
        GateLogic gate = ((ContainerGate)this.container).gate;
        TypedKeyMap<String, Object> properties = json.properties;
        FunctionContext context = json.context;
        properties.put("statement.container", gate);
        context.putConstantBoolean("gate.two_columns", gate.isSplitInTwo());
        context.putConstantLong("gate.slots", gate.variant.numSlots);
        context.putConstantLong("gate.triggers.args", gate.variant.numTriggerArgs);
        context.putConstantLong("gate.actions.args", gate.variant.numActionArgs);
        context.put_b("gate.two_columns", () -> gate.isOn);
        context.putConstant("gate.material", String.class, gate.variant.material.tag);
        context.putConstant("gate.logic", String.class, gate.variant.logic.tag);
        context.putConstant("gate.variant", String.class, gate.variant.getLocalizedName());
        properties.put("gate.triggers.possible", ((ContainerGate)this.container).possibleTriggersContext);
        properties.put("gate.actions.possible", ((ContainerGate)this.container).possibleActionsContext);
        context.put_l_b("gate.is_connected", i -> {
            if (i < 0L || i >= (long)gate.connections.length) {
                return false;
            }
            return gate.connections[(int)i];
        }).setNeverInline();
        context.put_l_b("gate.trigger.is_on", i -> {
            if (i < 0L || i >= (long)gate.triggerOn.length) {
                return false;
            }
            return gate.triggerOn[(int)i];
        }).setNeverInline();
        context.put_l_b("gate.set.is_on", i -> {
            if (i < 0L || i >= (long)gate.triggerOn.length) {
                return false;
            }
            return gate.actionOn[(int)i];
        }).setNeverInline();
        context.put_l_b("gate.action.is_on", i -> {
            if (i < 0L || i >= (long)gate.actionOn.length) {
                return false;
            }
            return gate.actionOn[(int)i] && gate.statements[(int)i].action.get() != null;
        }).setNeverInline();
        int s = 0;
        while (s < gate.variant.numSlots) {
            int i2 = s++;
            String tName = "gate.trigger/" + i2;
            String aName = "gate.action/" + i2;
            properties.put(tName, gate.statements[i2].trigger);
            properties.put(aName, gate.statements[i2].action);
            properties.put(tName, ((ContainerGate)this.container).possibleTriggersContext);
            properties.put(aName, ((ContainerGate)this.container).possibleActionsContext);
        }
        for (int c = 0; c < gate.connections.length; ++c) {
            int connection = c;
            String name = "gate.connection/" + c;
            properties.put(name, gate.connections[c]);
            properties.put(name, IButtonBehaviour.TOGGLE);
            properties.put(name, (b, k) -> ((ContainerGate)this.container).setConnected(connection, b.isButtonActive()));
        }
    }
}

