/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.item;

import buildcraft.api.transport.IItemPluggable;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.api.transport.pluggable.PluggableDefinition;
import buildcraft.lib.item.ItemBC_Neptune;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.SoundUtil;
import buildcraft.lib.misc.StackUtil;
import buildcraft.silicon.BCSiliconPlugs;
import buildcraft.silicon.gate.EnumGateLogic;
import buildcraft.silicon.gate.EnumGateMaterial;
import buildcraft.silicon.gate.GateVariant;
import buildcraft.silicon.plug.PluggableGate;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPluggableGate
extends ItemBC_Neptune
implements IItemPluggable {
    public ItemPluggableGate(String id) {
        super(id);
    }

    public static GateVariant getVariant(@Nonnull ItemStack stack) {
        return new GateVariant(NBTUtilBC.getItemData(stack).func_74775_l("gate"));
    }

    @Nonnull
    public ItemStack getStack(GateVariant variant) {
        ItemStack stack = new ItemStack((Item)this);
        NBTUtilBC.getItemData(stack).func_74782_a("gate", (NBTBase)variant.writeToNBT());
        return stack;
    }

    @Override
    public PipePluggable onPlace(@Nonnull ItemStack stack, IPipeHolder holder, EnumFacing side, EntityPlayer player, EnumHand hand) {
        GateVariant variant = ItemPluggableGate.getVariant(stack);
        SoundUtil.playBlockPlace(holder.getPipeWorld(), holder.getPipePos(), variant.material.block.func_176223_P());
        PluggableDefinition def = BCSiliconPlugs.gate;
        return new PluggableGate(def, holder, side, variant);
    }

    public String func_77653_i(ItemStack stack) {
        return ItemPluggableGate.getVariant(StackUtil.asNonNull(stack)).getLocalizedName();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        GateVariant variant = ItemPluggableGate.getVariant(StackUtil.asNonNull(stack));
        tooltip.add(LocaleUtil.localize("gate.slots", variant.numSlots));
        if (variant.numTriggerArgs == variant.numActionArgs) {
            if (variant.numTriggerArgs > 0) {
                tooltip.add(LocaleUtil.localize("gate.params", variant.numTriggerArgs));
            }
        } else {
            if (variant.numTriggerArgs > 0) {
                tooltip.add(LocaleUtil.localize("gate.params.trigger", variant.numTriggerArgs));
            }
            if (variant.numActionArgs > 0) {
                tooltip.add(LocaleUtil.localize("gate.params.action", variant.numTriggerArgs));
            }
        }
    }

    @Override
    protected void addSubItems(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        subItems.add((Object)new ItemStack((Item)this));
        for (EnumGateMaterial material : EnumGateMaterial.VALUES) {
            if (material == EnumGateMaterial.BASIC) continue;
            for (EnumGateLogic logic : EnumGateLogic.VALUES) {
                subItems.add((Object)this.getStack(new GateVariant(logic, material)));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addModelVariants(TIntObjectHashMap<ModelResourceLocation> variants) {
        variants.put(0, (Object)new ModelResourceLocation("buildcraftsilicon:gate_item#inventory"));
    }
}

