/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.BCModules;
import buildcraft.api.transport.pipe.EnumPipeColourType;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.api.transport.pipe.PipeDefinition;
import buildcraft.core.BCCoreConfig;
import buildcraft.lib.config.EnumRestartRequirement;
import buildcraft.lib.misc.ConfigUtil;
import buildcraft.lib.misc.MathUtil;
import buildcraft.transport.BCTransportPipes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BCTransportConfig {
    private static final long MJ_REQ_MILLIBUCKET_MIN = 100L;
    private static final long MJ_REQ_ITEM_MIN = 50000L;
    public static long mjPerMillibucket = 10000L;
    public static long mjPerItem = 100000L;
    public static int baseFlowRate = 10;
    public static boolean fluidPipeColourBorder;
    public static PowerLossMode lossMode;
    public static boolean pipeWrench;
    public static boolean pipeRightClick;
    private static Property propPipeWrench;
    private static Property propPipeRightClick;
    private static Property propMjPerMillibucket;
    private static Property propMjPerItem;
    private static Property propBaseFlowRate;
    private static Property propFluidPipeColourBorder;
    private static Property propLossMode;

    public static void preInit() {
        Configuration config = BCCoreConfig.config;
        propMjPerMillibucket = config.get("general", "pipes.mjPerMillibucket", (int)mjPerMillibucket).setMinValue(100);
        propMjPerMillibucket.setComment("Fluid pipe MJ per millibucket");
        EnumRestartRequirement.WORLD.setTo(propMjPerMillibucket);
        propMjPerItem = config.get("general", "pipes.mjPerItem", (int)mjPerItem).setMinValue(50000);
        propMjPerItem.setComment("Item pipe MJ per item");
        EnumRestartRequirement.WORLD.setTo(propMjPerItem);
        propBaseFlowRate = config.get("general", "pipes.baseFluidRate", baseFlowRate).setMinValue(1).setMaxValue(40);
        propBaseFlowRate.setComment("Fluid pipe base flow rate");
        EnumRestartRequirement.WORLD.setTo(propBaseFlowRate);
        propFluidPipeColourBorder = config.get("display", "pipes.fluidColourIsBorder", true);
        propFluidPipeColourBorder.setComment("Fluid pipe border color?");
        EnumRestartRequirement.WORLD.setTo(propFluidPipeColourBorder);
        propLossMode = config.get("experimental", "kinesisLossMode", "lossless");
        propLossMode.setComment("Lossless mode?");
        ConfigUtil.setEnumProperty((Property)propLossMode, (Enum[])PowerLossMode.VALUES);
        EnumRestartRequirement.WORLD.setTo(propLossMode);
        propPipeWrench = config.get("general", "pipes.wrenchRotate", true);
        propPipeWrench.setComment("Should a wrench be able to rotate directional pipes?");
        EnumRestartRequirement.WORLD.setTo(propPipeWrench);
        propPipeRightClick = config.get("general", "pipes.rightClickRotate", false);
        propPipeRightClick.setComment("Should shift right clicking be able to rotate directional pipes?");
        EnumRestartRequirement.WORLD.setTo(propPipeRightClick);
        MinecraftForge.EVENT_BUS.register(BCTransportConfig.class);
    }

    public static void reloadConfig(EnumRestartRequirement restarted) {
        if (EnumRestartRequirement.WORLD.hasBeenRestarted(restarted)) {
            mjPerMillibucket = propMjPerMillibucket.getLong();
            if (mjPerMillibucket < 100L) {
                mjPerMillibucket = 100L;
            }
            if ((mjPerItem = propMjPerItem.getLong()) < 50000L) {
                mjPerItem = 50000L;
            }
            baseFlowRate = MathUtil.clamp(propBaseFlowRate.getInt(), 1, 40);
            fluidPipeColourBorder = propFluidPipeColourBorder.getBoolean();
            PipeApi.flowFluids.fallbackColourType = fluidPipeColourBorder ? EnumPipeColourType.BORDER_INNER : EnumPipeColourType.TRANSLUCENT;
            lossMode = ConfigUtil.parseEnumForConfig(propLossMode, PowerLossMode.DEFAULT);
            pipeWrench = propPipeWrench.getBoolean();
            pipeRightClick = propPipeRightClick.getBoolean();
            BCTransportConfig.fluidTransfer(BCTransportPipes.cobbleFluid, baseFlowRate, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.woodFluid, baseFlowRate, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.stoneFluid, baseFlowRate * 2, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.sandstoneFluid, baseFlowRate * 2, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.clayFluid, baseFlowRate * 4, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.ironFluid, baseFlowRate * 4, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.quartzFluid, baseFlowRate * 4, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.diamondFluid, baseFlowRate * 8, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.emeraldFluid, baseFlowRate * 8, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.goldFluid, baseFlowRate * 8, 2);
            BCTransportConfig.fluidTransfer(BCTransportPipes.voidFluid, baseFlowRate * 8, 10);
            BCTransportConfig.powerTransfer(BCTransportPipes.cobblePower, 80, false);
            BCTransportConfig.powerTransfer(BCTransportPipes.stonePower, 160, false);
            BCTransportConfig.powerTransfer(BCTransportPipes.woodPower, 320, true);
            BCTransportConfig.powerTransfer(BCTransportPipes.sandstonePower, 320, false);
            BCTransportConfig.powerTransfer(BCTransportPipes.quartzPower, 640, false);
            BCTransportConfig.powerTransfer(BCTransportPipes.ironPower, 1280, false);
            BCTransportConfig.powerTransfer(BCTransportPipes.goldPower, 2560, false);
            BCTransportConfig.powerTransfer(BCTransportPipes.diamondPower, 10240, false);
            BCTransportConfig.powerTransfer(BCTransportPipes.emeraldPower, 2560, true);
        }
    }

    private static void fluidTransfer(PipeDefinition def, int rate, int delay) {
        PipeApi.fluidTransferData.put(def, new PipeApi.FluidTransferInfo(rate, delay));
    }

    private static void powerTransfer(PipeDefinition def, int transferMultiplier, boolean recv) {
        PipeApi.powerTransferData.put(def, PipeApi.PowerTransferInfo.create(transferMultiplier, recv));
    }

    @SubscribeEvent
    public static void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent cce) {
        if (BCModules.isBcMod(cce.getModID())) {
            EnumRestartRequirement req = EnumRestartRequirement.NONE;
            if (Loader.instance().isInState(LoaderState.AVAILABLE)) {
                req = EnumRestartRequirement.WORLD;
            }
            BCTransportConfig.reloadConfig(req);
        }
    }

    static {
        lossMode = PowerLossMode.DEFAULT;
        pipeWrench = true;
        pipeRightClick = false;
    }

    public static enum PowerLossMode {
        LOSSLESS,
        PERCENTAGE,
        ABSOLUTE;

        public static final PowerLossMode DEFAULT;
        public static final PowerLossMode[] VALUES;

        static {
            DEFAULT = LOSSLESS;
            VALUES = PowerLossMode.values();
        }
    }
}

