/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.transport.client.model.PipeModelCacheAll;
import buildcraft.transport.client.model.PipeModelCacheBase;
import buildcraft.transport.client.render.PipeFlowRendererItems;
import buildcraft.transport.pipe.behaviour.PipeBehaviourEmzuli;
import buildcraft.transport.pipe.behaviour.PipeBehaviourIronPower;
import java.util.EnumMap;
import java.util.Locale;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BCTransportSprites {
    public static final SpriteHolderRegistry.SpriteHolder EMPTY_FILTERED_BUFFER_SLOT;
    public static final SpriteHolderRegistry.SpriteHolder NOTHING_FILTERED_BUFFER_SLOT;
    public static final SpriteHolderRegistry.SpriteHolder PIPE_COLOUR;
    public static final SpriteHolderRegistry.SpriteHolder COLOUR_ITEM_BOX;
    public static final SpriteHolderRegistry.SpriteHolder PIPE_COLOUR_BORDER_OUTER;
    public static final SpriteHolderRegistry.SpriteHolder PIPE_COLOUR_BORDER_INNER;
    public static final SpriteHolderRegistry.SpriteHolder TRIGGER_POWER_REQUESTED;
    public static final SpriteHolderRegistry.SpriteHolder TRIGGER_POWER_TRAVERSING;
    public static final SpriteHolderRegistry.SpriteHolder TRIGGER_OVERLOADED;
    public static final SpriteHolderRegistry.SpriteHolder TRIGGER_ITEMS_TRAVERSING;
    public static final SpriteHolderRegistry.SpriteHolder TRIGGER_FLUIDS_TRAVERSING;
    public static final SpriteHolderRegistry.SpriteHolder[] ACTION_PIPE_COLOUR;
    public static final EnumMap<PipeBehaviourEmzuli.SlotIndex, SpriteHolderRegistry.SpriteHolder> ACTION_EXTRACTION_PRESET;
    private static final EnumMap<EnumDyeColor, SpriteHolderRegistry.SpriteHolder> PIPE_SIGNAL_ON;
    private static final EnumMap<EnumDyeColor, SpriteHolderRegistry.SpriteHolder> PIPE_SIGNAL_OFF;
    private static final EnumMap<EnumFacing, SpriteHolderRegistry.SpriteHolder> ACTION_PIPE_DIRECTION;
    private static final SpriteHolderRegistry.SpriteHolder[] ACTION_IRON_KINESIS;
    public static final SpriteHolderRegistry.SpriteHolder POWER_FLOW;
    public static final SpriteHolderRegistry.SpriteHolder POWER_FLOW_OVERLOAD;

    private static SpriteHolderRegistry.SpriteHolder getHolder(String loc) {
        return SpriteHolderRegistry.getHolder("buildcrafttransport:" + loc);
    }

    private static SpriteHolderRegistry.SpriteHolder getHolder(String module, String loc) {
        return SpriteHolderRegistry.getHolder("buildcraft" + module + ":" + loc);
    }

    public static void fmlPreInit() {
        MinecraftForge.EVENT_BUS.register(BCTransportSprites.class);
    }

    @SubscribeEvent
    public static void onTextureStitchPre(TextureStitchEvent.Pre event) {
        PipeModelCacheBase.generator.onTextureStitchPre(event.getMap());
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        PipeModelCacheAll.clearModels();
        PipeFlowRendererItems.onModelBake();
    }

    public static SpriteHolderRegistry.SpriteHolder getPipeSignal(boolean active, EnumDyeColor colour) {
        return (active ? PIPE_SIGNAL_ON : PIPE_SIGNAL_OFF).get(colour);
    }

    public static SpriteHolderRegistry.SpriteHolder getPipeDirection(EnumFacing face) {
        return ACTION_PIPE_DIRECTION.get(face);
    }

    public static SpriteHolderRegistry.SpriteHolder getIronKinesis(int index) {
        return ACTION_IRON_KINESIS[index];
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0_5;
        ACTION_IRON_KINESIS = new SpriteHolderRegistry.SpriteHolder[PipeBehaviourIronPower.LIMITER.length];
        EMPTY_FILTERED_BUFFER_SLOT = BCTransportSprites.getHolder("gui/empty_filtered_buffer_slot");
        NOTHING_FILTERED_BUFFER_SLOT = BCTransportSprites.getHolder("gui/nothing_filtered_buffer_slot");
        PIPE_COLOUR = BCTransportSprites.getHolder("pipes/overlay_stained");
        COLOUR_ITEM_BOX = BCTransportSprites.getHolder("pipes/colour_item_box");
        PIPE_COLOUR_BORDER_OUTER = BCTransportSprites.getHolder("pipes/colour_border_outer");
        PIPE_COLOUR_BORDER_INNER = BCTransportSprites.getHolder("pipes/colour_border_inner");
        ACTION_PIPE_COLOUR = new SpriteHolderRegistry.SpriteHolder[ColourUtil.COLOURS.length];
        for (EnumDyeColor enumDyeColor : ColourUtil.COLOURS) {
            BCTransportSprites.ACTION_PIPE_COLOUR[enumDyeColor.ordinal()] = BCTransportSprites.getHolder("core", "items/paintbrush/" + enumDyeColor.func_176610_l());
        }
        PIPE_SIGNAL_OFF = new EnumMap(EnumDyeColor.class);
        PIPE_SIGNAL_ON = new EnumMap(EnumDyeColor.class);
        for (EnumDyeColor enumDyeColor : ColourUtil.COLOURS) {
            String pre = "triggers/trigger_pipesignal_" + enumDyeColor.func_176610_l().toLowerCase(Locale.ROOT) + "_";
            PIPE_SIGNAL_OFF.put(enumDyeColor, BCTransportSprites.getHolder(pre + "inactive"));
            PIPE_SIGNAL_ON.put(enumDyeColor, BCTransportSprites.getHolder(pre + "active"));
        }
        ACTION_EXTRACTION_PRESET = new EnumMap(PipeBehaviourEmzuli.SlotIndex.class);
        for (PipeBehaviourEmzuli.SlotIndex slotIndex : PipeBehaviourEmzuli.SlotIndex.VALUES) {
            ACTION_EXTRACTION_PRESET.put(slotIndex, BCTransportSprites.getHolder("triggers/extraction_preset_" + slotIndex.colour.func_176610_l()));
        }
        ACTION_PIPE_DIRECTION = new EnumMap(EnumFacing.class);
        for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
            ACTION_PIPE_DIRECTION.put(enumFacing, BCTransportSprites.getHolder("core", "triggers/trigger_dir_" + enumFacing.func_176610_l().toLowerCase(Locale.ROOT)));
        }
        boolean bl = false;
        while (var0_5 < PipeBehaviourIronPower.LIMITER.length) {
            BCTransportSprites.ACTION_IRON_KINESIS[var0_5] = BCTransportSprites.getHolder("transport", "triggers/ironkinesis_" + (int)var0_5);
            ++var0_5;
        }
        POWER_FLOW = BCTransportSprites.getHolder("pipes/power_flow");
        POWER_FLOW_OVERLOAD = BCTransportSprites.getHolder("pipes/power_flow_overload");
        TRIGGER_POWER_REQUESTED = BCTransportSprites.getHolder("transport", "triggers/trigger_pipecontents_requestsenergy");
        TRIGGER_POWER_TRAVERSING = BCTransportSprites.getHolder("transport", "triggers/trigger_pipecontents_containsenergy");
        TRIGGER_OVERLOADED = BCTransportSprites.getHolder("transport", "triggers/trigger_pipecontents_toomuchenergy");
        TRIGGER_ITEMS_TRAVERSING = BCTransportSprites.getHolder("transport", "triggers/trigger_pipecontents_containsitems");
        TRIGGER_FLUIDS_TRAVERSING = BCTransportSprites.getHolder("transport", "triggers/trigger_pipecontents_containsfluids");
    }
}

