/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe.behaviour;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.PipeBehaviour;
import buildcraft.api.transport.pipe.PipeEventActionActivate;
import buildcraft.api.transport.pipe.PipeEventHandler;
import buildcraft.api.transport.pipe.PipeEventStatement;
import buildcraft.transport.BCTransportStatements;
import buildcraft.transport.pipe.flow.IVariableFlowHook;
import buildcraft.transport.pipe.flow.PipeFlowPower;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PipeBehaviourIronPower
extends PipeBehaviour
implements IVariableFlowHook {
    public static final int[] LIMITER = new int[]{20, 40, 80, 160, 320, 640, 1280, 0};
    private int limitedIndex = 0;

    public PipeBehaviourIronPower(IPipe pipe) {
        super(pipe);
    }

    public PipeBehaviourIronPower(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
        if (nbt.func_74764_b("index")) {
            this.limitedIndex = nbt.func_74762_e("index");
        }
    }

    @PipeEventHandler
    public void addInternalActions(PipeEventStatement.AddActionInternal event) {
        for (int i = 0; i < LIMITER.length; ++i) {
            event.actions.add(BCTransportStatements.ACTION_IRON_KINESES[i]);
        }
    }

    @PipeEventHandler
    public void onActionActivate(PipeEventActionActivate event) {
        for (int i = 0; i < LIMITER.length; ++i) {
            if (event.action != BCTransportStatements.ACTION_IRON_KINESES[i]) continue;
            this.limitedIndex = i;
            this.pipe.getHolder().scheduleNetworkUpdate(IPipeHolder.PipeMessageReceiver.BEHAVIOUR);
            if (!(this.pipe.getFlow() instanceof PipeFlowPower)) continue;
            ((PipeFlowPower)this.pipe.getFlow()).reconfigure();
        }
    }

    public void iterateLimiter() {
        ++this.limitedIndex;
        this.limitedIndex %= LIMITER.length;
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        nbt.func_74768_a("index", this.limitedIndex);
        return nbt;
    }

    @Override
    public void writePayload(PacketBuffer buffer, Side side) {
        super.writePayload(buffer, side);
        if (side == Side.SERVER) {
            buffer.writeInt(this.limitedIndex);
        }
    }

    @Override
    public void readPayload(PacketBuffer buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(buffer, side, ctx);
        if (side == Side.CLIENT) {
            this.limitedIndex = buffer.readInt();
        }
    }

    @Override
    public int getTextureIndex(EnumFacing face) {
        return this.limitedIndex;
    }

    @Override
    public boolean onPipeActivate(EntityPlayer player, RayTraceResult trace, float hitX, float hitY, float hitZ, EnumPipePart part) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        this.iterateLimiter();
        this.pipe.getHolder().scheduleNetworkUpdate(IPipeHolder.PipeMessageReceiver.BEHAVIOUR);
        if (this.pipe.getFlow() instanceof PipeFlowPower) {
            ((PipeFlowPower)this.pipe.getFlow()).reconfigure();
        }
        player.func_145747_a((ITextComponent)new TextComponentString("Switched to " + LIMITER[this.limitedIndex] + " RF/t limit"));
        return true;
    }

    @Override
    public int getMaxFlow() {
        return LIMITER[this.limitedIndex];
    }
}

