/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe.behaviour;

import buildcraft.api.mj.IMjRedstoneReceiver;
import buildcraft.api.mj.MjAPI;
import net.minecraftforge.energy.IEnergyStorage;

public class PipeRFWrapper
implements IEnergyStorage {
    private IMjRedstoneReceiver pipeReceiver;

    public PipeRFWrapper(IMjRedstoneReceiver pipeReceiver) {
        this.pipeReceiver = pipeReceiver;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        long mj = (long)maxReceive * MjAPI.MJ / (long)MjAPI.rfPerMj;
        long excess = this.pipeReceiver.receivePower(mj, true);
        long difference = mj - excess;
        int ret = this.mjToRf(difference);
        if (ret > 0) {
            this.pipeReceiver.receivePower(mj, simulate);
            return ret;
        }
        return 0;
    }

    private int mjToRf(long mj) {
        double rf = (double)(mj * (long)MjAPI.rfPerMj) / (double)MjAPI.MJ;
        return (int)Math.ceil(rf);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return 0;
    }

    public int getMaxEnergyStored() {
        return 512;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return this.pipeReceiver.canReceive();
    }
}

