/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe.flow;

import buildcraft.api.core.BCLog;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.IFluidFilter;
import buildcraft.api.core.IFluidHandlerAdv;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.transport.pipe.IFlowFluid;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.api.transport.pipe.PipeDefinition;
import buildcraft.api.transport.pipe.PipeEventFluid;
import buildcraft.api.transport.pipe.PipeEventHandler;
import buildcraft.api.transport.pipe.PipeEventStatement;
import buildcraft.api.transport.pipe.PipeFlow;
import buildcraft.core.BCCoreConfig;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.MathUtil;
import buildcraft.lib.misc.StringUtilBC;
import buildcraft.lib.misc.VecUtil;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.net.cache.BuildCraftObjectCaches;
import buildcraft.lib.net.cache.NetworkedObjectCache;
import buildcraft.transport.BCTransportStatements;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PipeFlowFluids
extends PipeFlow
implements IFlowFluid,
IDebuggable {
    private static final int DIRECTION_COOLDOWN = 60;
    private static final int COOLDOWN_INPUT = -60;
    private static final int COOLDOWN_OUTPUT = 60;
    private static final ActionResult<FluidStack> FAILED_EXTRACT = new ActionResult(EnumActionResult.FAIL, null);
    private static final ActionResult<FluidStack> PASSED_EXTRACT = new ActionResult(EnumActionResult.PASS, null);
    public static final int NET_FLUID_AMOUNTS = 2;
    public static final double FLOW_MULTIPLIER = 0.016;
    public final PipeApi.FluidTransferInfo fluidTransferInfo;
    public final int capacity;
    private final Map<EnumPipePart, Section> sections;
    private FluidStack currentFluid;
    private int currentDelay;
    private final SafeTimeTracker tracker;
    private long lastMessage;
    private long lastMessageMinus1;
    private NetworkedObjectCache.Link clientFluid;

    public PipeFlowFluids(IPipe pipe) {
        super(pipe);
        this.fluidTransferInfo = PipeApi.getFluidTransferInfo(this.pipe.getDefinition());
        this.capacity = Math.max(1000, this.fluidTransferInfo.transferPerTick * 10);
        this.sections = new EnumMap<EnumPipePart, Section>(EnumPipePart.class);
        this.tracker = new SafeTimeTracker(BCCoreConfig.networkUpdateRate, 4L);
        this.clientFluid = null;
        for (EnumPipePart part : EnumPipePart.VALUES) {
            this.sections.put(part, new Section(part));
        }
    }

    public PipeFlowFluids(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
        this.fluidTransferInfo = PipeApi.getFluidTransferInfo(this.pipe.getDefinition());
        this.capacity = Math.max(1000, this.fluidTransferInfo.transferPerTick * 10);
        this.sections = new EnumMap<EnumPipePart, Section>(EnumPipePart.class);
        this.tracker = new SafeTimeTracker(BCCoreConfig.networkUpdateRate, 4L);
        this.clientFluid = null;
        for (EnumPipePart part : EnumPipePart.VALUES) {
            this.sections.put(part, new Section(part));
        }
        if (nbt.func_74764_b("fluid")) {
            this.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("fluid")));
        } else {
            this.setFluid(null);
        }
        for (EnumPipePart part : EnumPipePart.VALUES) {
            int direction = part.getIndex();
            if (!nbt.func_74764_b("tank[" + direction + "]")) continue;
            NBTTagCompound compound = nbt.func_74775_l("tank[" + direction + "]");
            if (compound.func_74764_b("FluidType")) {
                FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound);
                if (this.currentFluid == null) {
                    this.setFluid(stack);
                }
                if (stack == null || !stack.isFluidEqual(this.currentFluid)) continue;
                this.sections.get((Object)part).readFromNbt(compound);
                continue;
            }
            this.sections.get((Object)part).readFromNbt(compound);
        }
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        if (this.currentFluid != null) {
            NBTTagCompound fluidTag = new NBTTagCompound();
            this.currentFluid.writeToNBT(fluidTag);
            nbt.func_74782_a("fluid", (NBTBase)fluidTag);
            for (EnumPipePart part : EnumPipePart.VALUES) {
                int direction = part.getIndex();
                NBTTagCompound subTag = new NBTTagCompound();
                this.sections.get((Object)part).writeToNbt(subTag);
                nbt.func_74782_a("tank[" + direction + "]", (NBTBase)subTag);
            }
        }
        return nbt;
    }

    @Override
    public boolean canConnect(EnumFacing face, PipeFlow other) {
        return other instanceof IFlowFluid;
    }

    @Override
    public boolean canConnect(EnumFacing face, TileEntity oTile) {
        return oTile.hasCapability(CapUtil.CAP_FLUIDS, face.func_176734_d());
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapUtil.CAP_FLUIDS) {
            return (T)CapUtil.CAP_FLUIDS.cast((Object)this.sections.get((Object)EnumPipePart.fromFacing(facing)));
        }
        return super.getCapability(capability, facing);
    }

    public boolean doesContainFluid() {
        for (EnumPipePart part : EnumPipePart.VALUES) {
            if (this.sections.get((Object)((Object)part)).amount <= 0) continue;
            return true;
        }
        return false;
    }

    @PipeEventHandler
    public static void addTriggers(PipeEventStatement.AddTriggerInternal event) {
        event.triggers.add(BCTransportStatements.TRIGGER_FLUIDS_TRAVERSING);
    }

    @Override
    public FluidStack tryExtractFluid(int millibuckets, EnumFacing from, FluidStack filter, boolean simulate) {
        FluidExtractor extractor = (mb, c, handler) -> {
            FluidStack f = filter == null ? c : filter;
            return PipeFlowFluids.extractSimple(mb, f, handler, simulate);
        };
        return (FluidStack)this.tryExtractFluidInternal(millibuckets, from, extractor, simulate).func_188398_b();
    }

    @Override
    public ActionResult<FluidStack> tryExtractFluidAdv(int millibuckets, EnumFacing from, IFluidFilter filter, boolean simulate) {
        FluidExtractor extractor = (mb, c, handler) -> {
            if (c != null) {
                if (!filter.matches(c)) {
                    return null;
                }
                return PipeFlowFluids.extractSimple(mb, c, handler, simulate);
            }
            if (handler instanceof IFluidHandlerAdv) {
                IFluidHandlerAdv handlerAdv = (IFluidHandlerAdv)handler;
                return handlerAdv.drain(filter, mb, !simulate);
            }
            IFluidTankProperties[] tanks = handler.getTankProperties();
            if (tanks == null) {
                return null;
            }
            for (IFluidTankProperties tank : tanks) {
                FluidStack extracted;
                FluidStack contents = tank.getContents();
                if (contents == null || !filter.matches(contents) || (extracted = PipeFlowFluids.extractSimple(mb, contents, handler, simulate)) == null) continue;
                return extracted;
            }
            return null;
        };
        return this.tryExtractFluidInternal(millibuckets, from, extractor, simulate);
    }

    private ActionResult<FluidStack> tryExtractFluidInternal(int millibuckets, EnumFacing from, FluidExtractor extractor, boolean simulate) {
        if (from == null || millibuckets <= 0) {
            return FAILED_EXTRACT;
        }
        IFluidHandler fluidHandler = this.pipe.getHolder().getCapabilityFromPipe(from, CapUtil.CAP_FLUIDS);
        if (fluidHandler == null) {
            return PASSED_EXTRACT;
        }
        Section section = this.sections.get((Object)EnumPipePart.fromFacing(from));
        Section middle = this.sections.get((Object)EnumPipePart.CENTER);
        if ((millibuckets = Math.min(millibuckets, this.capacity * 2 - section.amount - middle.amount)) <= 0) {
            return FAILED_EXTRACT;
        }
        FluidStack toAdd = extractor.extract(millibuckets, this.currentFluid, fluidHandler);
        if (toAdd == null || toAdd.amount <= 0) {
            return FAILED_EXTRACT;
        }
        millibuckets = toAdd.amount;
        if (this.currentFluid == null && !simulate) {
            this.setFluid(toAdd);
        }
        int reallyFilled = section.fillInternal(millibuckets, !simulate);
        int leftOver = millibuckets - reallyFilled;
        reallyFilled += middle.fillInternal(leftOver, !simulate);
        if (!simulate) {
            section.ticksInDirection = -60;
        }
        if (reallyFilled != millibuckets) {
            BCLog.logger.warn("[tryExtractFluidAdv] Filled " + reallyFilled + " != extracted " + millibuckets + " (handler = " + fluidHandler.getClass() + ") @" + this.pipe.getHolder().getPipePos());
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)toAdd);
    }

    private static FluidStack extractSimple(int millibuckets, FluidStack filter, IFluidHandler handler, boolean simulate) {
        if (filter == null) {
            return handler.drain(millibuckets, !simulate);
        }
        filter = filter.copy();
        filter.amount = millibuckets;
        FluidStack drained = handler.drain(filter, !simulate);
        if (drained != null && !filter.isFluidEqual(filter)) {
            String detail = "(Filter = " + StringUtilBC.fluidToString(filter);
            detail = detail + ",\nactually drained = " + StringUtilBC.fluidToString(drained) + ")";
            detail = detail + ",\nIFluidHandler = " + handler.getClass() + "(" + handler + ")";
            throw new IllegalStateException("Drained fluid did not equal filter fluid!\n" + detail);
        }
        return drained;
    }

    @Override
    public int insertFluidsForce(FluidStack fluid, @Nullable EnumFacing from, boolean simulate) {
        int filled;
        Section s = this.sections.get((Object)EnumPipePart.CENTER);
        if (fluid == null || fluid.amount == 0) {
            return 0;
        }
        if (this.currentFluid != null && !this.currentFluid.isFluidEqual(fluid)) {
            return 0;
        }
        if (this.currentFluid == null && !simulate) {
            this.setFluid(fluid.copy());
        }
        if ((filled = s.fill(fluid.amount, !simulate)) == 0) {
            return 0;
        }
        if (simulate) {
            return filled;
        }
        if (from != null) {
            this.sections.get((Object)((Object)EnumPipePart.fromFacing((EnumFacing)from))).ticksInDirection = -60;
        }
        return filled;
    }

    @Override
    @Nullable
    public FluidStack extractFluidsForce(int min, int max, @Nullable EnumFacing section, boolean simulate) {
        if (min > max) {
            throw new IllegalArgumentException("Minimum (" + min + ") > maximum (" + max + ")");
        }
        if (max < 0) {
            return null;
        }
        Section s = this.sections.get((Object)EnumPipePart.fromFacing(section));
        if (s.amount < min) {
            return null;
        }
        int amount = MathUtil.clamp(s.amount, min, max);
        FluidStack fluid = new FluidStack(this.currentFluid, amount);
        if (!simulate) {
            s.amount -= amount;
            s.drainInternal(amount, false);
            if (s.amount == 0) {
                boolean isEmpty = true;
                for (Section s2 : this.sections.values()) {
                    isEmpty &= s2.amount == 0;
                }
                if (isEmpty) {
                    this.setFluid(null);
                }
            }
        }
        return fluid;
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        boolean isRemote = this.pipe.getHolder().getPipeWorld().field_72995_K;
        FluidStack fluid = isRemote ? this.getFluidStackForRender() : this.currentFluid;
        left.add(" - FluidType = " + (fluid == null ? "empty" : fluid.getLocalizedName()));
        for (EnumPipePart part : EnumPipePart.VALUES) {
            Section section = this.sections.get((Object)part);
            if (section == null) continue;
            StringBuilder line = new StringBuilder(" - " + LocaleUtil.localizeFacing(part.face) + " = ");
            int amount = isRemote ? section.target : section.amount;
            line.append(amount > 0 ? TextFormatting.GREEN : "");
            line.append(amount).append("").append(TextFormatting.RESET).append("mB");
            line.append(" ").append((Object)section.getCurrentDirection()).append(" (").append(section.ticksInDirection).append(")");
            line.append(" [");
            int last = -1;
            int skipped = 0;
            for (int i : section.incoming) {
                if (i != last) {
                    if (skipped > 0) {
                        line.append("...").append(skipped).append("... ");
                        skipped = 0;
                    }
                    last = i;
                    line.append(i).append(", ");
                    continue;
                }
                ++skipped;
            }
            if (skipped > 0) {
                line.append("...").append(skipped).append("... ");
                skipped = 0;
            }
            line.append("0]");
            left.add(line.toString());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public FluidStack getFluidStackForRender() {
        return this.clientFluid == null ? null : (FluidStack)this.clientFluid.get();
    }

    @SideOnly(value=Side.CLIENT)
    public double[] getAmountsForRender(float partialTicks) {
        double[] arr = new double[7];
        for (EnumPipePart part : EnumPipePart.VALUES) {
            Section s = this.sections.get((Object)part);
            arr[part.getIndex()] = (float)s.clientAmountLast * (1.0f - partialTicks) + (float)s.clientAmountThis * partialTicks;
        }
        return arr;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d[] getOffsetsForRender(float partialTicks) {
        Vec3d[] arr = new Vec3d[7];
        for (EnumPipePart part : EnumPipePart.VALUES) {
            Section s = this.sections.get((Object)part);
            if (!(s.offsetLast != null & s.offsetThis != null)) continue;
            arr[part.getIndex()] = s.offsetLast.func_186678_a((double)(1.0f - partialTicks)).func_178787_e(s.offsetThis.func_186678_a((double)partialTicks));
        }
        return arr;
    }

    private void setFluid(FluidStack fluid) {
        this.currentFluid = fluid;
        this.currentDelay = fluid != null ? (int)PipeApi.getFluidTransferInfo((PipeDefinition)this.pipe.getDefinition()).transferDelayMultiplier : (int)PipeApi.getFluidTransferInfo((PipeDefinition)this.pipe.getDefinition()).transferDelayMultiplier;
        for (Section section : this.sections.values()) {
            section.incoming = new int[this.currentDelay];
            section.currentTime = 0;
            section.ticksInDirection = 0;
        }
    }

    @Override
    public void onTick() {
        World world = this.pipe.getHolder().getPipeWorld();
        if (world.field_72995_K) {
            for (EnumPipePart part : EnumPipePart.VALUES) {
                this.sections.get((Object)part).tickClient();
            }
            return;
        }
        if (this.currentFluid != null) {
            Section section;
            int totalFluid = 0;
            boolean canOutput = false;
            for (EnumPipePart part : EnumPipePart.VALUES) {
                section = this.sections.get((Object)part);
                section.currentTime = (section.currentTime + 1) % this.currentDelay;
                section.advanceForMovement();
                totalFluid += section.amount;
                if (!section.getCurrentDirection().canOutput()) continue;
                canOutput = true;
            }
            if (totalFluid == 0) {
                this.setFluid(null);
            } else {
                if (canOutput) {
                    this.moveFromPipe();
                }
                this.moveFromCenter();
                this.moveToCenter();
            }
            EnumPipePart[] enumPipePartArray = EnumPipePart.VALUES;
            int n = enumPipePartArray.length;
            for (int i = 0; i < n; ++i) {
                EnumPipePart part;
                part = enumPipePartArray[i];
                section = this.sections.get((Object)part);
                if (section.ticksInDirection > 0) {
                    --section.ticksInDirection;
                    continue;
                }
                if (section.ticksInDirection >= 0) continue;
                ++section.ticksInDirection;
            }
        }
        boolean send = false;
        for (EnumPipePart part : EnumPipePart.VALUES) {
            Section section = this.sections.get((Object)part);
            if (section.amount != section.lastSentAmount) {
                send = true;
                break;
            }
            Dir should = Dir.get(section.ticksInDirection);
            if (section.lastSentDirection == should) continue;
            send = true;
            break;
        }
        if (send && this.tracker.markTimeIfDelay(world)) {
            this.sendPayload(2);
        }
    }

    private void moveFromPipe() {
        for (EnumPipePart part : EnumPipePart.FACES) {
            int filled;
            IFluidHandler fluidHandler;
            int maxDrain;
            Section section = this.sections.get((Object)part);
            if (!section.getCurrentDirection().canOutput() || (maxDrain = section.drainInternal(this.fluidTransferInfo.transferPerTick, false)) <= 0) continue;
            PipeEventFluid.SideCheck sideCheck = new PipeEventFluid.SideCheck(this.pipe.getHolder(), this, this.currentFluid);
            sideCheck.disallowAllExcept(part.face);
            this.pipe.getHolder().fireEvent(sideCheck);
            if (sideCheck.getOrder().size() != 1 || (fluidHandler = this.pipe.getHolder().getCapabilityFromPipe(part.face, CapUtil.CAP_FLUIDS)) == null) continue;
            FluidStack fluidToPush = new FluidStack(this.currentFluid, maxDrain);
            if (fluidToPush.amount <= 0 || (filled = fluidHandler.fill(fluidToPush, true)) <= 0) continue;
            section.drainInternal(filled, true);
            section.ticksInDirection = 60;
        }
    }

    private void moveFromCenter() {
        Section center = this.sections.get((Object)EnumPipePart.CENTER);
        int totalAvailable = center.getMaxDrained();
        if (totalAvailable < 1) {
            return;
        }
        int flowRate = this.fluidTransferInfo.transferPerTick;
        EnumSet<EnumFacing> realDirections = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            Section section = this.sections.get((Object)EnumPipePart.fromFacing(direction));
            if (!section.getCurrentDirection().canOutput() || section.getMaxFilled() <= 0 || this.pipe.getHolder().getCapabilityFromPipe(direction, CapUtil.CAP_FLUIDS) == null) continue;
            realDirections.add(direction);
        }
        if (realDirections.size() > 0) {
            PipeEventFluid.SideCheck sideCheck = new PipeEventFluid.SideCheck(this.pipe.getHolder(), this, this.currentFluid);
            sideCheck.disallowAllExcept(realDirections);
            this.pipe.getHolder().fireEvent(sideCheck);
            EnumSet<EnumFacing> set = sideCheck.getOrder();
            ArrayList<EnumFacing> random = new ArrayList<EnumFacing>(set);
            Collections.shuffle(random);
            float min = (float)Math.min(flowRate * realDirections.size(), totalAvailable) / (float)flowRate / (float)realDirections.size();
            for (EnumFacing direction : random) {
                int filled;
                Section section = this.sections.get((Object)EnumPipePart.fromFacing(direction));
                int available = section.fill(flowRate, false);
                int amountToPush = (int)((float)available * min);
                if (amountToPush < 1) {
                    ++amountToPush;
                }
                if ((amountToPush = center.drainInternal(amountToPush, false)) <= 0 || (filled = section.fill(amountToPush, true)) <= 0) continue;
                center.drainInternal(filled, true);
                section.ticksInDirection = 60;
            }
        }
    }

    private void moveToCenter() {
        int transferInCount = 0;
        Section center = this.sections.get((Object)EnumPipePart.CENTER);
        int spaceAvailable = this.capacity - center.amount;
        if (spaceAvailable <= 0 || center.getMaxFilled() <= 0) {
            return;
        }
        int flowRate = this.fluidTransferInfo.transferPerTick;
        ArrayList faces = new ArrayList();
        Collections.addAll(faces, EnumPipePart.FACES);
        Collections.shuffle(faces);
        int[] inputPerTick = new int[6];
        for (EnumPipePart part : faces) {
            Section section = this.sections.get((Object)part);
            inputPerTick[part.getIndex()] = 0;
            if (!section.getCurrentDirection().canInput()) continue;
            inputPerTick[part.getIndex()] = section.drainInternal(flowRate, false);
            if (inputPerTick[part.getIndex()] <= 0) continue;
            ++transferInCount;
        }
        int[] totalOffered = Arrays.copyOf(inputPerTick, 6);
        PipeEventFluid.PreMoveToCentre preMove = new PipeEventFluid.PreMoveToCentre(this.pipe.getHolder(), this, this.currentFluid, Math.min(flowRate, spaceAvailable), totalOffered, inputPerTick);
        this.pipe.getHolder().fireEvent(preMove);
        int[] fluidLeavingSide = new int[6];
        int left = Math.min(flowRate, spaceAvailable);
        float min = (float)Math.min(flowRate * transferInCount, spaceAvailable) / (float)flowRate / (float)transferInCount;
        for (EnumPipePart part : EnumPipePart.FACES) {
            int amountToPush;
            Section section = this.sections.get((Object)part);
            int i = part.getIndex();
            if (inputPerTick[i] <= 0) continue;
            int amountToDrain = (int)((float)inputPerTick[i] * min);
            if (amountToDrain < 1) {
                ++amountToDrain;
            }
            if (amountToDrain > left) {
                amountToDrain = left;
            }
            if ((amountToPush = section.drainInternal(amountToDrain, false)) <= 0) continue;
            fluidLeavingSide[i] = amountToPush;
            left -= amountToPush;
        }
        int[] fluidEnteringCentre = Arrays.copyOf(fluidLeavingSide, 6);
        PipeEventFluid.OnMoveToCentre move = new PipeEventFluid.OnMoveToCentre(this.pipe.getHolder(), this, this.currentFluid, fluidLeavingSide, fluidEnteringCentre);
        this.pipe.getHolder().fireEvent(move);
        for (EnumPipePart part : EnumPipePart.FACES) {
            int actuallyFilled;
            int entering;
            Section section = this.sections.get((Object)part);
            int i = part.getIndex();
            int leaving = fluidLeavingSide[i];
            if (leaving <= 0) continue;
            int actuallyDrained = section.drainInternal(leaving, true);
            if (actuallyDrained != leaving) {
                throw new IllegalStateException("Couldn't drain " + leaving + " from " + (Object)((Object)part) + ", only drained " + actuallyDrained);
            }
            if (actuallyDrained > 0) {
                section.ticksInDirection = -60;
            }
            if ((entering = fluidEnteringCentre[i]) <= 0 || (actuallyFilled = center.fill(entering, true)) == entering) continue;
            throw new IllegalStateException("Couldn't fill " + entering + " from " + (Object)((Object)part) + ", only filled " + actuallyFilled);
        }
    }

    @Override
    public void writePayload(int id, PacketBuffer buf, Side side) {
        PacketBufferBC buffer = PacketBufferBC.asPacketBufferBc((ByteBuf)buf);
        if (side == Side.SERVER && (id == 2 || id == 0)) {
            boolean full;
            boolean bl = full = id == 0;
            if (this.currentFluid == null) {
                buffer.writeBoolean(false);
            } else {
                buffer.writeBoolean(true);
                buffer.writeInt(BuildCraftObjectCaches.CACHE_FLUIDS.server().store(this.currentFluid));
            }
            for (EnumPipePart part : EnumPipePart.VALUES) {
                Section section = this.sections.get((Object)part);
                if (full) {
                    buffer.writeShort(section.amount);
                } else if (section.amount == section.lastSentAmount) {
                    buffer.writeBoolean(false);
                } else {
                    buffer.writeBoolean(true);
                    buffer.writeShort(section.amount);
                    section.lastSentAmount = section.amount;
                }
                Dir should = Dir.get(section.ticksInDirection);
                buffer.writeEnumValue(should);
                section.lastSentDirection = should;
            }
        }
    }

    @Override
    public void readPayload(int id, PacketBuffer buf, Side side) throws IOException {
        PacketBufferBC buffer = PacketBufferBC.asPacketBufferBc((ByteBuf)buf);
        if (side == Side.CLIENT && (id == 2 || id == 0)) {
            boolean full;
            boolean bl = full = id == 0;
            if (buffer.readBoolean()) {
                int fluidId = buffer.readInt();
                this.clientFluid = BuildCraftObjectCaches.CACHE_FLUIDS.client().retrieve(fluidId);
            }
            for (EnumPipePart part : EnumPipePart.VALUES) {
                Dir dir;
                Section section = this.sections.get((Object)part);
                if (full || buffer.readBoolean()) {
                    section.target = buffer.readShort();
                    if (full) {
                        section.clientAmountLast = section.clientAmountThis = section.target;
                    }
                }
                section.ticksInDirection = (dir = buffer.func_179257_a(Dir.class)) == Dir.NONE ? 0 : (dir == Dir.IN ? -60 : 60);
            }
            this.lastMessageMinus1 = this.lastMessage;
            this.lastMessage = this.pipe.getHolder().getPipeWorld().func_82737_E();
        }
    }

    static enum Dir {
        IN(-1),
        NONE(0),
        OUT(1);

        final byte nbtValue;

        private Dir(int nbtValue) {
            this.nbtValue = (byte)nbtValue;
        }

        public boolean isInput() {
            return this == IN;
        }

        public boolean canInput() {
            return this != OUT;
        }

        public boolean isOutput() {
            return this == OUT;
        }

        public boolean canOutput() {
            return this != IN;
        }

        public static Dir get(int dir) {
            if (dir == 0) {
                return NONE;
            }
            if (dir < 0) {
                return IN;
            }
            return OUT;
        }
    }

    class Section
    implements IFluidHandler {
        final EnumPipePart part;
        int amount = 0;
        int lastSentAmount = 0;
        Dir lastSentDirection = Dir.NONE;
        int currentTime = 0;
        int[] incoming = new int[1];
        int incomingTotalCache = 0;
        int ticksInDirection = 0;
        int clientAmountThis;
        int clientAmountLast;
        int target = 0;
        Vec3d offsetLast;
        Vec3d offsetThis;

        Section(EnumPipePart part) {
            this.part = part;
        }

        void writeToNbt(NBTTagCompound nbt) {
            nbt.func_74777_a("capacity", (short)this.amount);
            nbt.func_74777_a("lastSentAmount", (short)this.lastSentAmount);
            nbt.func_74777_a("ticksInDirection", (short)this.ticksInDirection);
            for (int i = 0; i < this.incoming.length; ++i) {
                nbt.func_74777_a("in[" + i + "]", (short)this.incoming[i]);
            }
        }

        void readFromNbt(NBTTagCompound nbt) {
            this.amount = nbt.func_74765_d("capacity");
            this.lastSentAmount = nbt.func_74765_d("lastSentAmount");
            this.ticksInDirection = nbt.func_74765_d("ticksInDirection");
            this.incomingTotalCache = 0;
            for (int i = 0; i < this.incoming.length; ++i) {
                short s = nbt.func_74765_d("in[" + i + "]");
                this.incoming[i] = s;
                this.incomingTotalCache += s;
            }
        }

        int getMaxFilled() {
            int availableTotal = PipeFlowFluids.this.capacity - this.amount;
            int availableThisTick = PipeFlowFluids.this.fluidTransferInfo.transferPerTick - this.incoming[this.currentTime];
            return Math.min(availableTotal, availableThisTick);
        }

        int getMaxDrained() {
            return Math.min(this.amount - this.incomingTotalCache, PipeFlowFluids.this.fluidTransferInfo.transferPerTick);
        }

        int fill(int maxFill, boolean doFill) {
            int amountToFill = Math.min(this.getMaxFilled(), maxFill);
            if (amountToFill <= 0) {
                return 0;
            }
            if (doFill) {
                int n = this.currentTime;
                this.incoming[n] = this.incoming[n] + amountToFill;
                this.incomingTotalCache += amountToFill;
                this.amount += amountToFill;
            }
            return amountToFill;
        }

        public int fillInternal(int maxFill, boolean doFill) {
            int amountToFill = Math.min(PipeFlowFluids.this.capacity - this.amount, maxFill);
            if (amountToFill <= 0) {
                return 0;
            }
            if (doFill) {
                int n = this.currentTime;
                this.incoming[n] = this.incoming[n] + amountToFill;
                this.incomingTotalCache += amountToFill;
                this.amount += amountToFill;
            }
            return amountToFill;
        }

        int drainInternal(int maxDrain, boolean doDrain) {
            if ((maxDrain = Math.min(maxDrain, this.getMaxDrained())) <= 0) {
                return 0;
            }
            if (doDrain) {
                this.amount -= maxDrain;
            }
            return maxDrain;
        }

        void advanceForMovement() {
            this.incomingTotalCache -= this.incoming[this.currentTime];
            this.incoming[this.currentTime] = 0;
        }

        void setTime(int current) {
            this.currentTime = current;
        }

        Dir getCurrentDirection() {
            Dir dir = this.ticksInDirection == 0 ? Dir.NONE : (this.ticksInDirection < 0 ? Dir.IN : Dir.OUT);
            return dir;
        }

        boolean tickClient() {
            double dz;
            double dy;
            double dx;
            this.clientAmountLast = this.clientAmountThis;
            if (this.target != this.clientAmountThis) {
                int delta = this.target - this.clientAmountThis;
                long msgDelta = PipeFlowFluids.this.lastMessage - PipeFlowFluids.this.lastMessageMinus1;
                msgDelta = MathUtil.clamp((int)msgDelta, 1, 60);
                this.clientAmountThis = (long)Math.abs(delta) < msgDelta ? (this.clientAmountThis += delta) : (this.clientAmountThis += delta / (int)msgDelta);
            }
            if (this.offsetThis == null || this.clientAmountThis == 0 && this.clientAmountLast == 0) {
                this.offsetThis = Vec3d.field_186680_a;
            }
            this.offsetLast = this.offsetThis;
            if (this.part.face == null) {
                Section s;
                Vec3d dir = Vec3d.field_186680_a;
                for (EnumPipePart p : EnumPipePart.FACES) {
                    s = (Section)PipeFlowFluids.this.sections.get((Object)p);
                    if (s.ticksInDirection <= 0) continue;
                    dir = dir.func_178787_e(new Vec3d(p.face.func_176730_m()));
                }
                for (EnumPipePart p : EnumPipePart.FACES) {
                    s = (Section)PipeFlowFluids.this.sections.get((Object)p);
                    if (s.ticksInDirection >= 0) continue;
                    dir = dir.func_178787_e(new Vec3d(p.face.func_176730_m()).func_186678_a(-1.0));
                }
                dir = new Vec3d(Math.signum(dir.field_72450_a), Math.signum(dir.field_72448_b), Math.signum(dir.field_72449_c));
                this.offsetThis = this.offsetThis.func_178787_e(dir.func_186678_a(-0.016));
            } else {
                double mult = Math.signum(this.ticksInDirection);
                this.offsetThis = VecUtil.offset(this.offsetLast, this.part.face, -0.016 * mult);
            }
            double d = this.offsetThis.field_72450_a >= 0.5 ? -1.0 : (dx = this.offsetThis.field_72450_a <= 0.5 ? 1.0 : 0.0);
            double d2 = this.offsetThis.field_72448_b >= 0.5 ? -1.0 : (dy = this.offsetThis.field_72448_b <= 0.5 ? 1.0 : 0.0);
            double d3 = this.offsetThis.field_72449_c >= 0.5 ? -1.0 : (dz = this.offsetThis.field_72449_c <= 0.5 ? 1.0 : 0.0);
            if (dx != 0.0 || dy != 0.0 || dz != 0.0) {
                this.offsetThis = this.offsetThis.func_72441_c(dx, dy, dz);
                this.offsetLast = this.offsetLast.func_72441_c(dx, dy, dz);
            }
            return this.clientAmountThis > 0 | this.clientAmountLast > 0;
        }

        @Deprecated
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Deprecated
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[0];
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (!this.getCurrentDirection().canInput() || !PipeFlowFluids.this.pipe.isConnected(this.part.face) || resource == null) {
                return 0;
            }
            resource = resource.copy();
            PipeEventFluid.TryInsert tryInsert = new PipeEventFluid.TryInsert(PipeFlowFluids.this.pipe.getHolder(), PipeFlowFluids.this, this.part.face, resource);
            PipeFlowFluids.this.pipe.getHolder().fireEvent(tryInsert);
            if (tryInsert.isCanceled()) {
                return 0;
            }
            if (PipeFlowFluids.this.currentFluid == null || PipeFlowFluids.this.currentFluid.isFluidEqual(resource)) {
                int filled;
                if (doFill && PipeFlowFluids.this.currentFluid == null) {
                    PipeFlowFluids.this.setFluid(resource.copy());
                }
                if ((filled = this.fill(resource.amount, doFill)) > 0 && doFill) {
                    this.ticksInDirection = -60;
                }
                return filled;
            }
            return 0;
        }
    }

    @FunctionalInterface
    private static interface FluidExtractor {
        public FluidStack extract(int var1, FluidStack var2, IFluidHandler var3);
    }
}

