/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe.flow;

import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.transport.pipe.IFlowPower;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.api.transport.pipe.PipeEventPower;
import buildcraft.api.transport.pipe.PipeFlow;
import buildcraft.lib.misc.VecUtil;
import buildcraft.lib.misc.data.AverageDouble;
import buildcraft.lib.misc.data.AverageInt;
import buildcraft.transport.net.PacketPowerUpdate;
import buildcraft.transport.pipe.Pipe;
import buildcraft.transport.pipe.flow.IPipeTransportPowerHook;
import buildcraft.transport.pipe.flow.IVariableFlowHook;
import buildcraft.transport.tile.TilePipeHolder;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;

public class PipeFlowPower
extends PipeFlow
implements IDebuggable,
IFlowPower,
IEnergyStorage {
    private static final int DEFAULT_MAX_POWER = 100;
    public static final int NET_POWER_AMOUNTS = 2;
    public Vec3d clientDisplayFlowCentre = Vec3d.field_186680_a;
    public Vec3d clientDisplayFlowCentreLast = Vec3d.field_186680_a;
    public int maxPower = -1;
    public boolean isReceiver = false;
    public double[] clientDisplayFlow = new double[6];
    public double[] clientDisplayFlowLast = new double[6];
    private static final int OVERLOAD_TICKS = 60;
    public AverageDouble[] displayPowerAverage = new AverageDouble[6];
    public double[] displayPower = new double[6];
    public short[] displayFlow = new short[6];
    public int[] nextPowerQuery = new int[6];
    public double[] internalNextPower = new double[6];
    public int overload;
    public int[] dbgEnergyInput = new int[6];
    public int[] dbgEnergyOutput = new int[6];
    public int[] dbgEnergyOffered = new int[6];
    private final AverageInt[] powerAverage = new AverageInt[6];
    private final TileEntity[] tiles = new TileEntity[6];
    private final Object[] providers = new Object[6];
    private boolean needsInit = true;
    private int[] powerQuery = new int[6];
    private long currentDate;
    private double[] internalPower = new double[6];
    int counter = 0;
    private SafeTimeTracker tracker = new SafeTimeTracker(20L);
    public boolean[] powerSources = new boolean[6];
    private int requestedEnergy;
    private int sources;
    private int energy;
    private final int capacity = 2560;

    public PipeFlowPower(IPipe pipe) {
        super(pipe);
        for (int i = 0; i < 6; ++i) {
            this.powerAverage[i] = new AverageInt(8);
        }
    }

    public boolean isPowerSource(TileEntity t, EnumFacing o) {
        if (t == null) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                this.updateTile(side);
            }
            return false;
        }
        IEnergyStorage storage = (IEnergyStorage)t.getCapability(CapabilityEnergy.ENERGY, o.func_176734_d());
        return storage != null && storage.getEnergyStored() > 0;
    }

    @Override
    public boolean canConnect(EnumFacing face, PipeFlow other) {
        return other instanceof PipeFlowPower;
    }

    @Override
    public boolean canConnect(EnumFacing face, TileEntity oTile) {
        return oTile.hasCapability(CapabilityEnergy.ENERGY, face.func_176734_d());
    }

    @Override
    public void reconfigure() {
        PipeEventPower.Configure configure = new PipeEventPower.Configure(this.pipe.getHolder(), this);
        PipeApi.PowerTransferInfo pti = PipeApi.getPowerTransferInfo(this.pipe.getDefinition());
        configure.setReceiver(pti.isReceiver);
        configure.setMaxPower(pti.transferPerTick);
        if (this.pipe.getBehaviour() instanceof IVariableFlowHook) {
            int maxRF = ((IVariableFlowHook)((Object)this.pipe.getBehaviour())).getMaxFlow();
            configure.setMaxPower(maxRF);
        }
        this.pipe.getHolder().fireEvent(configure);
        this.isReceiver = configure.isReceiver();
        this.maxPower = configure.getMaxPower();
        if (this.maxPower < 0) {
            this.maxPower = 100;
        }
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this);
        }
        return null;
    }

    @Override
    public void onTick() {
        if (this.maxPower == -1) {
            this.reconfigure();
        }
        for (int i = 0; i < 6; ++i) {
            if (this.internalPower[i] < 1.0) {
                this.internalPower[i] = 0.0;
            }
            if (!(this.internalNextPower[i] < 1.0)) continue;
            this.internalNextPower[i] = 0.0;
        }
        if (this.pipe.getHolder().getPipeWorld().field_72995_K) {
            this.clientDisplayFlowCentreLast = this.clientDisplayFlowCentre;
            for (EnumFacing face : EnumFacing.field_82609_l) {
                this.clientDisplayFlowLast[face.ordinal()] = this.clientDisplayFlow[face.ordinal()];
                double diff = (double)this.displayFlow[face.ordinal()] * 2.4 * (double)face.func_176743_c().func_179524_a();
                int n = face.ordinal();
                this.clientDisplayFlow[n] = this.clientDisplayFlow[n] + (16.0 + diff);
                int n2 = face.ordinal();
                this.clientDisplayFlow[n2] = this.clientDisplayFlow[n2] % 16.0;
                double cVal = VecUtil.getValue(this.clientDisplayFlowCentre, face.func_176740_k());
                cVal += 16.0 + diff / 2.0;
                cVal %= 16.0;
                if (this.displayFlow[face.ordinal()] == 0) {
                    cVal = 0.0;
                }
                this.clientDisplayFlowCentre = VecUtil.replaceValue(this.clientDisplayFlowCentre, face.func_176740_k(), cVal);
            }
        }
        this.updateEntity();
    }

    private void step2() {
        if (this.pipe != null && this.pipe.getHolder().getPipeWorld() != null && this.currentDate != this.pipe.getHolder().getPipeWorld().func_82737_E()) {
            this.currentDate = this.pipe.getHolder().getPipeWorld().func_82737_E();
            Arrays.fill(this.dbgEnergyInput, 0);
            Arrays.fill(this.dbgEnergyOffered, 0);
            Arrays.fill(this.dbgEnergyOutput, 0);
            this.powerQuery = this.nextPowerQuery;
            this.nextPowerQuery = new int[6];
            double[] next = this.internalPower;
            this.internalPower = this.internalNextPower;
            this.internalNextPower = next;
        }
    }

    public boolean requestingPower() {
        int sum = 0;
        for (int i : this.nextPowerQuery) {
            sum += i;
        }
        for (int i : this.powerQuery) {
            sum += i;
        }
        return sum > 0;
    }

    public boolean powerFlowing() {
        double sum = 0.0;
        for (AverageInt av : this.powerAverage) {
            sum += av.getAverage();
        }
        return sum > 0.0;
    }

    private void updateTile(EnumFacing side) {
        int o = side.ordinal();
        TileEntity tile = this.pipe.getConnectedTile(side);
        if (tile != null && this.pipe.isConnected(side)) {
            this.tiles[o] = tile;
        } else {
            this.tiles[o] = null;
            this.internalPower[o] = 0.0;
            this.internalNextPower[o] = 0.0;
            this.powerAverage[o].clear();
            this.displayFlow[o] = 0;
        }
        if (tile instanceof TilePipeHolder && ((TilePipeHolder)tile).getPipe().getFlow() instanceof PipeFlowPower) {
            this.providers[o] = ((TilePipeHolder)tile).getPipe();
        } else if (tile != null && tile.hasCapability(CapabilityEnergy.ENERGY, side.func_176734_d())) {
            this.providers[o] = tile.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d());
        }
    }

    private void init() {
        if (this.needsInit) {
            this.needsInit = false;
            for (EnumFacing side : EnumFacing.field_82609_l) {
                this.updateTile(side);
            }
        }
    }

    public void updateEntity() {
        int i;
        if (this.pipe.getHolder().getPipeWorld().field_72995_K) {
            for (int i2 = 0; i2 < 6; ++i2) {
                if (this.displayPowerAverage[i2] == null) {
                    this.displayPowerAverage[i2] = new AverageDouble(8);
                }
                this.displayPowerAverage[i2].tick(this.displayPower[i2]);
            }
            return;
        }
        short[] lastFlows = new short[6];
        double[] lastDisplayPower = new double[6];
        for (EnumFacing face : EnumFacing.field_82609_l) {
            int i3 = face.ordinal();
            lastFlows[i3] = this.displayFlow[i3];
            lastDisplayPower[i3] = this.displayPower[i3];
        }
        ++this.counter;
        this.step2();
        this.init();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if ((this.tiles[side.ordinal()] == null || !this.tiles[side.ordinal()].func_145837_r()) && this.counter % 5 != 0) continue;
            this.updateTile(side);
        }
        for (int i4 = 0; i4 < 6; ++i4) {
            if (!(this.internalPower[i4] > 0.0)) continue;
            int totalPowerQuery = 0;
            for (int j = 0; j < 6; ++j) {
                Object ep;
                if (j == i4 || this.powerQuery[j] <= 0 || !((ep = this.providers[j]) instanceof IPipe) && !(ep instanceof IEnergyStorage)) continue;
                totalPowerQuery += this.powerQuery[j];
            }
            if (totalPowerQuery <= 0) continue;
            int unusedPowerQuery = totalPowerQuery;
            for (int j = 0; j < 6; ++j) {
                IEnergyStorage handler;
                if (j == i4 || this.powerQuery[j] <= 0) continue;
                Object ep = this.providers[j];
                double watts = Math.min(this.internalPower[i4] * (double)this.powerQuery[j] / (double)unusedPowerQuery, this.internalPower[i4]);
                unusedPowerQuery -= this.powerQuery[j];
                if (ep instanceof IPipe && ((IPipe)ep).getFlow() instanceof PipeFlowPower) {
                    PipeFlowPower nearbyTransport = (PipeFlowPower)((IPipe)ep).getFlow();
                    watts = nearbyTransport.receiveEnergy(EnumFacing.field_82609_l[j].func_176734_d(), watts);
                    int n = i4;
                    this.internalPower[n] = this.internalPower[n] - watts;
                    int n2 = j;
                    this.dbgEnergyOutput[n2] = (int)((double)this.dbgEnergyOutput[n2] + watts);
                    this.powerAverage[j].push((int)Math.ceil(watts));
                    this.powerAverage[i4].push((int)Math.ceil(watts));
                    this.displayFlow[i4] = 1;
                    this.displayFlow[j] = -1;
                    continue;
                }
                int iWatts = (int)watts;
                if (ep instanceof IEnergyStorage && (handler = (IEnergyStorage)ep).canReceive()) {
                    iWatts = handler.receiveEnergy(iWatts, false);
                }
                int n = i4;
                this.internalPower[n] = this.internalPower[n] - (double)iWatts;
                int n3 = j;
                this.dbgEnergyOutput[n3] = this.dbgEnergyOutput[n3] + iWatts;
                this.powerAverage[j].push(iWatts);
                this.powerAverage[i4].push(iWatts);
                this.displayFlow[i4] = 1;
                this.displayFlow[j] = -1;
            }
        }
        double highestPower = 0.0;
        for (int i5 = 0; i5 < 6; ++i5) {
            this.powerAverage[i5].tick();
            double value = this.powerAverage[i5].getAverage() / (double)this.maxPower;
            this.displayPower[i5] = value = Math.sqrt(value);
            if (!(this.displayPower[i5] > highestPower)) continue;
            highestPower = this.displayPower[i5];
        }
        this.overload += highestPower > (double)((float)this.maxPower * 0.95f) ? 1 : -1;
        if (this.overload < 0) {
            this.overload = 0;
        }
        if (this.overload > 60) {
            this.overload = 60;
        }
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            IEnergyStorage handler;
            int request;
            Object tile;
            if (!this.pipe.isConnected(dir) || (tile = this.providers[dir.ordinal()]) instanceof IPipe && ((IPipe)tile).getFlow() instanceof PipeFlowPower || tile instanceof TilePipeHolder && ((TilePipeHolder)tile).getPipe().getFlow() instanceof PipeFlowPower || !(tile instanceof IEnergyStorage) || this.isReceiver || (request = (handler = (IEnergyStorage)tile).receiveEnergy(this.maxPower, true)) <= 0) continue;
            this.requestEnergy(dir, request);
        }
        int[] transferQuery = new int[6];
        for (i = 0; i < 6; ++i) {
            transferQuery[i] = 0;
            if (!this.pipe.isConnected(EnumFacing.field_82609_l[i])) continue;
            for (int j = 0; j < 6; ++j) {
                if (j == i) continue;
                int n = i;
                transferQuery[n] = transferQuery[n] + this.powerQuery[j];
            }
            transferQuery[i] = Math.min(transferQuery[i], this.maxPower);
        }
        for (i = 0; i < 6; ++i) {
            Pipe pipe;
            TileEntity entity;
            if (transferQuery[i] == 0 || this.tiles[i] == null || !((entity = this.tiles[i]) instanceof TilePipeHolder) || !((pipe = ((TilePipeHolder)entity).getPipe()).getFlow() instanceof PipeFlowPower)) continue;
            ((PipeFlowPower)pipe.getFlow()).requestEnergy(EnumFacing.field_82609_l[i].func_176734_d(), transferQuery[i]);
        }
        boolean didChange = false;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            int i6 = face.ordinal();
            if (lastFlows[i6] != this.displayFlow[i6] || lastDisplayPower[i6] != this.displayPower[i6]) {
                didChange = true;
            }
            if (this.powerQuery[i6] != 0 || this.powerAverage[i6].getAverage() == 0.0 || this.internalNextPower[i6] != 0.0 || this.internalPower[i6] != 0.0) continue;
            didChange = true;
        }
        if (didChange || this.tracker.markTimeIfDelay(this.pipe.getHolder().getPipeWorld())) {
            this.sendPayload(2);
        }
        if (this.isReceiver) {
            this.sources = 0;
            for (EnumFacing o : EnumFacing.field_82609_l) {
                boolean oldPowerSource = this.powerSources[o.ordinal()];
                if (this.pipe.getConnectedType(o) != IPipe.ConnectedType.TILE) {
                    this.powerSources[o.ordinal()] = false;
                } else {
                    TileEntity tile = this.pipe.getConnectedTile(o);
                    this.powerSources[o.ordinal()] = this.isPowerSource(tile, o);
                    if (this.isPowerSource(tile, o)) {
                        ++this.sources;
                    }
                }
                if (oldPowerSource == this.powerSources[o.ordinal()]) continue;
                this.pipe.markForUpdate();
            }
            if (this.pipe.getHolder().getPipeWorld().field_72995_K) {
                return;
            }
            if (this.sources <= 0) {
                this.extractEnergy(50, false);
                this.requestedEnergy = 0;
                return;
            }
            int energyToRemove = Math.min(this.getEnergyStored(), this.requestedEnergy);
            energyToRemove /= this.sources;
            if (this.getEnergyStored() > 0) {
                for (EnumFacing o : EnumFacing.field_82609_l) {
                    if (!this.powerSources[o.ordinal()]) continue;
                    this.energy -= (int)this.receiveEnergy(o, energyToRemove);
                }
            }
            this.requestedEnergy = 0;
        }
    }

    @Override
    public void writePayload(int id, PacketBuffer buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER && (id == 2 || id == 0)) {
            buffer.writeBoolean(this.isOverloaded());
            for (int i = 0; i < this.displayPower.length; ++i) {
                buffer.writeDouble(this.displayPower[i]);
                buffer.writeByte((int)this.displayFlow[i]);
            }
        }
        buffer.writeInt(this.energy);
    }

    @Override
    public void readPayload(int id, PacketBuffer buffer, Side side) throws IOException {
        super.readPayload(id, buffer, side);
        if (side == Side.CLIENT && (id == 2 || id == 0)) {
            this.displayPower = new double[6];
            this.displayFlow = new short[6];
            this.overload = buffer.readBoolean() ? 60 : 0;
            for (int i = 0; i < this.displayPower.length; ++i) {
                this.displayPower[i] = buffer.readDouble();
                this.displayFlow[i] = buffer.readByte();
            }
        }
        this.energy = buffer.readInt();
    }

    public void handlePowerPacket(PacketPowerUpdate packetPower) {
    }

    public boolean isOverloaded() {
        return this.overload >= 60;
    }

    public boolean isOverloaded2() {
        for (AverageInt i : this.powerAverage) {
            if (!(Math.abs((double)this.maxPower - i.getAverage()) < 0.5)) continue;
            return true;
        }
        return false;
    }

    public double receiveEnergy(EnumFacing from, double tVal) {
        double ret;
        int side = from.ordinal();
        double val = tVal;
        this.step2();
        int n = side;
        this.dbgEnergyOffered[n] = (int)((double)this.dbgEnergyOffered[n] + val);
        if (this.pipe instanceof IPipeTransportPowerHook && (ret = (double)((IPipeTransportPowerHook)((Object)this.pipe)).receivePower(from, (int)val)) >= 0.0) {
            return ret;
        }
        if (this.internalNextPower[side] > (double)this.maxPower) {
            return 0.0;
        }
        int n2 = side;
        this.internalNextPower[n2] = this.internalNextPower[n2] + val;
        if (this.internalNextPower[side] > (double)this.maxPower) {
            val -= this.internalNextPower[side] - (double)this.maxPower;
            this.internalNextPower[side] = this.maxPower;
            if (val < 0.0) {
                val = 0.0;
            }
        }
        int n3 = side;
        this.dbgEnergyInput[n3] = (int)((double)this.dbgEnergyInput[n3] + val);
        return val;
    }

    public void requestEnergy(EnumFacing from, int amount) {
        TileEntity te;
        if (this.isReceiver && (te = this.pipe.getConnectedTile(from)) != null && te.hasCapability(CapabilityEnergy.ENERGY, from.func_176734_d())) {
            this.requestedEnergy += amount;
        }
        this.step2();
        if (this.pipe instanceof IPipeTransportPowerHook) {
            int n = from.ordinal();
            this.nextPowerQuery[n] = this.nextPowerQuery[n] + ((IPipeTransportPowerHook)((Object)this.pipe)).requestPower(from, amount);
        } else {
            int n = from.ordinal();
            this.nextPowerQuery[n] = this.nextPowerQuery[n] + amount;
        }
    }

    public PipeFlowPower(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
        int i;
        for (i = 0; i < 6; ++i) {
            this.powerQuery[i] = nbt.func_74762_e("powerQuery[" + i + "]");
            this.nextPowerQuery[i] = nbt.func_74762_e("nextPowerQuery[" + i + "]");
            this.internalPower[i] = nbt.func_74762_e("internalPower[" + i + "]");
            this.internalNextPower[i] = nbt.func_74762_e("internalNextPower[" + i + "]");
            this.powerAverage[i] = new AverageInt(8);
        }
        if (this.isReceiver) {
            for (i = 0; i < EnumFacing.field_82609_l.length; ++i) {
                this.powerSources[i] = nbt.func_74767_n("powerSources[" + i + "]");
            }
        }
        this.energy = nbt.func_74762_e("rf");
    }

    @Override
    public NBTTagCompound writeToNbt() {
        int i;
        NBTTagCompound nbttagcompound = super.writeToNbt();
        for (i = 0; i < 6; ++i) {
            nbttagcompound.func_74768_a("powerQuery[" + i + "]", this.powerQuery[i]);
            nbttagcompound.func_74768_a("nextPowerQuery[" + i + "]", this.nextPowerQuery[i]);
            nbttagcompound.func_74780_a("internalPower[" + i + "]", this.internalPower[i]);
            nbttagcompound.func_74780_a("internalNextPower[" + i + "]", this.internalNextPower[i]);
        }
        if (this.isReceiver) {
            for (i = 0; i < EnumFacing.field_82609_l.length; ++i) {
                nbttagcompound.func_74757_a("powerSources[" + i + "]", this.powerSources[i]);
            }
        }
        nbttagcompound.func_74768_a("rf", this.energy);
        return nbttagcompound;
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        StringBuilder s = new StringBuilder();
        StringBuilder s2 = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            if (this.powerAverage[i] != null) {
                s.append(this.powerAverage[i].toString()).append(" ");
            }
            if (this.displayPowerAverage[i] == null) continue;
            s2.append(this.displayPowerAverage[i].toString()).append(" ");
        }
        left.add("averagepower" + s);
        right.add("displayPower" + Arrays.toString(this.displayPower));
        right.add("dpAverage" + s2);
        right.add("flow" + Arrays.toString(this.displayFlow));
        left.add("query: " + Arrays.toString(this.powerQuery));
        left.add("internal: " + Arrays.toString(this.internalPower) + "<-" + Arrays.toString(this.internalNextPower));
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.isReceiver) {
            return 0;
        }
        int energyReceived = Math.min(2560 - this.energy, Math.min(2560, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.isReceiver ? this.energy : 0;
    }

    public int getMaxEnergyStored() {
        return this.isReceiver ? 2560 : 0;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return this.isReceiver;
    }
}

