/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.wire;

import buildcraft.api.core.BCLog;
import buildcraft.api.transport.EnumWirePart;
import buildcraft.api.transport.IWireEmitter;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.lib.net.MessageManager;
import buildcraft.transport.wire.MessageWireSystems;
import buildcraft.transport.wire.MessageWireSystemsPowered;
import buildcraft.transport.wire.WireSystem;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.commons.lang3.tuple.Pair;

public class WorldSavedDataWireSystems
extends WorldSavedData {
    public static final String DATA_NAME = "buildcraft_wire_systems";
    public World world;
    public final Map<WireSystem, Boolean> wireSystems = new HashMap<WireSystem, Boolean>();
    public boolean gatesChanged = true;
    public boolean structureChanged = true;
    public final List<WireSystem> changedSystems = new ArrayList<WireSystem>();
    public final List<EntityPlayerMP> changedPlayers = new ArrayList<EntityPlayerMP>();
    public final Map<WireSystem.WireElement, IWireEmitter> emittersCache = new HashMap<WireSystem.WireElement, IWireEmitter>();
    private final Map<WireSystem.WireElement, List<WireSystem>> elementsToWireSystemsIndex = new HashMap<WireSystem.WireElement, List<WireSystem>>();

    public WorldSavedDataWireSystems() {
        super(DATA_NAME);
    }

    public WorldSavedDataWireSystems(String name) {
        super(name);
    }

    public void markStructureChanged() {
        this.structureChanged = true;
        this.gatesChanged = true;
        this.emittersCache.clear();
    }

    public List<WireSystem> getWireSystemsWithElement(WireSystem.WireElement element) {
        List<WireSystem> wireSystemsWithElement = this.elementsToWireSystemsIndex.get(element);
        return wireSystemsWithElement != null ? new ArrayList<WireSystem>(wireSystemsWithElement) : Collections.emptyList();
    }

    public List<WireSystem> getWireSystemsWithElementAsReadOnlyList(WireSystem.WireElement element) {
        return this.elementsToWireSystemsIndex.getOrDefault(element, Collections.emptyList());
    }

    public void removeWireSystem(WireSystem wireSystem) {
        this.wireSystems.remove(wireSystem);
        wireSystem.elements.forEach(elementIn -> this.elementsToWireSystemsIndex.computeIfPresent((WireSystem.WireElement)elementIn, (element, wireSystems) -> {
            wireSystems.remove(wireSystem);
            return wireSystems.isEmpty() ? null : wireSystems;
        }));
        this.markStructureChanged();
    }

    public void addWireSystem(WireSystem wireSystem, boolean powered) {
        if (this.wireSystems.put(wireSystem, powered) == null) {
            wireSystem.elements.forEach(systemElement -> {
                List wireSystemsWithElement = this.elementsToWireSystemsIndex.computeIfAbsent((WireSystem.WireElement)systemElement, unused -> new ArrayList());
                if (wireSystemsWithElement.contains(wireSystem)) {
                    throw new IllegalStateException();
                }
                wireSystemsWithElement.add(wireSystem);
            });
        }
    }

    public void buildAndAddWireSystem(WireSystem.WireElement element) {
        WireSystem wireSystem = new WireSystem(this, element);
        if (!wireSystem.isEmpty()) {
            this.addWireSystem(wireSystem, false);
            this.wireSystems.put(wireSystem, wireSystem.update(this));
        }
        this.markStructureChanged();
    }

    public void rebuildWireSystemsAround(IPipeHolder holder) {
        Arrays.stream(EnumWirePart.values()).flatMap(part -> WireSystem.getConnectedElementsOfElement(this.world, new WireSystem.WireElement(holder.getPipePos(), (EnumWirePart)((Object)part))).stream()).distinct().forEach(this::buildAndAddWireSystem);
    }

    public IWireEmitter getEmitter(WireSystem.WireElement element) {
        if (element.type == WireSystem.WireElement.Type.EMITTER_SIDE) {
            if (!this.emittersCache.containsKey(element)) {
                IPipeHolder holder;
                PipePluggable plug;
                TileEntity tile;
                if (!this.world.func_175667_e(element.blockPos)) {
                    BCLog.logger.warn("[transport.wire] Ghost loading " + element.blockPos + " to look for an emitter!");
                }
                if ((tile = this.world.func_175625_s(element.blockPos)) instanceof IPipeHolder && (plug = (holder = (IPipeHolder)tile).getPluggable(element.emitterSide)) instanceof IWireEmitter) {
                    this.emittersCache.put(element, (IWireEmitter)((Object)plug));
                }
                if (!this.emittersCache.containsKey(element)) {
                    throw new IllegalStateException("Tried to get a wire element when none existed! THIS IS A BUG " + element);
                }
            }
            return this.emittersCache.get(element);
        }
        return null;
    }

    public boolean isEmitterEmitting(WireSystem.WireElement element, EnumDyeColor color) {
        IPipeHolder holder;
        TileEntity tile;
        if (!this.world.func_175667_e(element.blockPos)) {
            BCLog.logger.warn("[transport.wire] Ghost loading " + element.blockPos + " to look for an emitter!");
        }
        if ((tile = this.world.func_175625_s(element.blockPos)) instanceof IPipeHolder && (holder = (IPipeHolder)tile).getPluggable(element.emitterSide) instanceof IWireEmitter) {
            return this.getEmitter(element).isEmitting(color);
        }
        return false;
    }

    public void tick() {
        if (this.gatesChanged) {
            this.wireSystems.replaceAll((wireSystem, oldPowered) -> {
                boolean newPowered = wireSystem.update(this);
                if (oldPowered != newPowered) {
                    this.changedSystems.add((WireSystem)wireSystem);
                }
                return newPowered;
            });
        }
        this.world.func_175661_b(EntityPlayerMP.class, Predicates.alwaysTrue()).forEach(player -> {
            Map<Integer, Boolean> hashesPowered;
            Map<Integer, WireSystem> changedWires = this.wireSystems.keySet().stream().filter(wireSystem -> wireSystem.isPlayerWatching((EntityPlayerMP)player) && (this.structureChanged || this.changedPlayers.contains(player))).collect(Collectors.toMap(WireSystem::getWiresHashCode, Function.identity()));
            if (!changedWires.isEmpty()) {
                MessageManager.sendTo(new MessageWireSystems(changedWires), player);
            }
            if (!(hashesPowered = this.wireSystems.entrySet().stream().filter(systemPower -> ((WireSystem)systemPower.getKey()).isPlayerWatching((EntityPlayerMP)player) && (this.structureChanged || this.changedSystems.contains(systemPower.getKey()) || this.changedPlayers.contains(player))).map(systemPowered -> Pair.of((Object)((WireSystem)systemPowered.getKey()).getWiresHashCode(), systemPowered.getValue())).collect(Collectors.toMap(Pair::getLeft, Pair::getRight))).isEmpty()) {
                MessageManager.sendTo(new MessageWireSystemsPowered(hashesPowered), player);
            }
        });
        if (this.structureChanged || !this.changedSystems.isEmpty()) {
            this.func_76185_a();
        }
        this.structureChanged = false;
        this.changedSystems.clear();
        this.changedPlayers.clear();
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagList entriesList = new NBTTagList();
        this.wireSystems.forEach((wireSystem, powered) -> {
            NBTTagCompound entry = new NBTTagCompound();
            entry.func_74782_a("wireSystem", (NBTBase)wireSystem.writeToNBT());
            entry.func_74757_a("powered", powered.booleanValue());
            entriesList.func_74742_a((NBTBase)entry);
        });
        nbt.func_74782_a("entries", (NBTBase)entriesList);
        return nbt;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.wireSystems.clear();
        this.elementsToWireSystemsIndex.clear();
        NBTTagList entriesList = nbt.func_150295_c("entries", 10);
        for (int i = 0; i < entriesList.func_74745_c(); ++i) {
            NBTTagCompound entry = entriesList.func_150305_b(i);
            this.addWireSystem(new WireSystem(entry.func_74775_l("wireSystem")), entry.func_74767_n("powered"));
        }
    }

    public static WorldSavedDataWireSystems get(World world) {
        if (world.field_72995_K) {
            throw new UnsupportedOperationException("Attempted to get WorldSavedDataWireSystems on the client!");
        }
        MapStorage storage = world.getPerWorldStorage();
        WorldSavedDataWireSystems instance = (WorldSavedDataWireSystems)storage.func_75742_a(WorldSavedDataWireSystems.class, DATA_NAME);
        if (instance == null) {
            instance = new WorldSavedDataWireSystems();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        instance.world = world;
        return instance;
    }
}

