/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.ic2cuumatter.integration.jei.category;

import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.core.IC2;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Property;

public class MassFabricatorCategory
implements IRecipeCategory<MassFabricatorRecipe> {
    public static String UID = "ic2cuumatter.mass_fabricator";
    IDrawable background;
    IDrawable background_fix;
    MassFabricatorRecipe recipe;

    public MassFabricatorCategory(IGuiHelper helper, ResourceLocation texture) {
        this.background = helper.createDrawable(texture, 48, 13, 133, 69);
        this.background_fix = helper.drawableBuilder(texture, 4, 4, 3, 69).build();
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return Ic2BlockLang.massFabricator.getLocalized();
    }

    public String getModName() {
        return "ic2cuumatter";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, MassFabricatorRecipe recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 65, 4);
        guiItemStacks.init(1, true, 65, 40);
        guiItemStacks.set(ingredients);
        this.recipe = recipeWrapper;
    }

    public void drawExtras(Minecraft minecraft) {
        this.background_fix.draw(minecraft, 125, 0);
    }

    public static final class MassFabricatorRecipe
    implements IRecipeWrapper {
        public String amplifierValue;
        public ItemStack inputItem;
        public ItemStack outputItem;
        IMachineRecipeList.RecipeEntry entry;

        public MassFabricatorRecipe(ItemStack itemInput, ItemStack itemOutput, @Nullable String amplifierValue) {
            this.amplifierValue = amplifierValue;
            this.inputItem = itemInput;
            this.outputItem = itemOutput;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.outputItem);
            ingredients.setInput(VanillaTypes.ITEM, (Object)this.inputItem);
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            FontRenderer font = minecraft.field_71466_p;
            String tierHV = I18n.func_135052_a((String)"translation.ic2cuumatter.tier.hv", (Object[])new Object[0]);
            font.func_78276_b(tierHV, 0, 0, 0x404040);
            String energy = I18n.func_135052_a((String)"translation.ic2cuumatter.energy", (Object[])new Object[0]);
            font.func_78276_b(energy, 0, 52, 0x404040);
            font.func_78276_b("512 EU/t", 90, 62, 0x404040);
            double euScrap = Double.parseDouble("" + ((Property)IC2.config.getConfig().getCategory("balance").getValues().get("EUPerUU")).getDouble() * 1166666.0);
            double euNoScrap = Double.parseDouble("" + ((Property)IC2.config.getConfig().getCategory("balance").getValues().get("EUPerUU")).getDouble() * 7000000.0);
            if (this.amplifierValue != null) {
                String amplifier = I18n.func_135052_a((String)"translation.ic2cuumatter.amplifier", (Object[])new Object[0]);
                font.func_78276_b(amplifier, 90, 21, 0x404040);
                if (this.amplifierValue == "100,000") {
                    font.func_78276_b(I18n.func_135052_a((String)("+ " + this.amplifierValue), (Object[])new Object[0]), 86, 31, 0x404040);
                }
                if (this.amplifierValue == "45,000") {
                    font.func_78276_b(I18n.func_135052_a((String)("+ " + this.amplifierValue), (Object[])new Object[0]), 92, 31, 0x404040);
                }
                if (this.amplifierValue == "5,000") {
                    font.func_78276_b(I18n.func_135052_a((String)("+ " + this.amplifierValue), (Object[])new Object[0]), 98, 31, 0x404040);
                }
                font.func_78276_b(String.format("%,.0f", euScrap) + " EU", 0, 62, 0x404040);
            } else {
                font.func_78276_b(String.format("%,.0f", euNoScrap) + " EU", 0, 62, 0x404040);
            }
        }
    }
}

