/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.immersion.stacks;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.List;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.block.BlockBase;
import pl.asie.charset.lib.material.ItemMaterial;
import pl.asie.charset.lib.material.ItemMaterialRegistry;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.lib.utils.RayTraceUtils;
import pl.asie.charset.lib.utils.UnlistedPropertyGeneric;
import pl.asie.charset.module.immersion.stacks.CharsetImmersionStacks;
import pl.asie.charset.module.immersion.stacks.StackShapes;
import pl.asie.charset.module.immersion.stacks.TileEntityStacks;

public class BlockStacks
extends BlockBase
implements ITileEntityProvider {
    protected static final UnlistedPropertyGeneric<TileEntityStacks> PROPERTY_TILE = new UnlistedPropertyGeneric("tile", TileEntityStacks.class);
    private final WeakHashMap<EntityPlayer, Long> cooldownMap = new WeakHashMap();

    public BlockStacks() {
        super(Material.field_151573_f);
        this.setFullCube(false);
        this.setOpaqueCube(false);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.0f);
        this.func_149663_c("charset.stacks");
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        TileEntity tile;
        RayTraceResult result = this.func_180636_a(state, worldIn, pos, RayTraceUtils.getStart((EntityLivingBase)Minecraft.func_71410_x().field_71439_g), RayTraceUtils.getEnd((EntityLivingBase)Minecraft.func_71410_x().field_71439_g));
        if (result != null && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityStacks) {
            int id = result.subHit & 0x3F;
            return StackShapes.getIngotBox(id, ((TileEntityStacks)tile).stacks[id]).func_186670_a(pos);
        }
        return state.func_185900_c((IBlockAccess)worldIn, pos).func_186670_a(pos);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityStacks) {
            for (int i = 0; i < 64; ++i) {
                if (((TileEntityStacks)tile).stacks[i] == null) continue;
                BlockStacks.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)StackShapes.getIngotBox(i, ((TileEntityStacks)tile).stacks[i]));
            }
        } else {
            BlockStacks.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185505_j);
        }
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityStacks) {
            double distance = Double.MAX_VALUE;
            RayTraceResult resultOut = null;
            for (int i = 0; i < 64; ++i) {
                double dist;
                RayTraceResult result;
                if (((TileEntityStacks)tile).stacks[i] == null || (result = this.func_185503_a(pos, start, end, StackShapes.getIngotBox(i, ((TileEntityStacks)tile).stacks[i]))) == null || !((dist = result.field_72307_f.func_72436_e(start)) < distance)) continue;
                resultOut = result;
                resultOut.subHit = i;
                distance = dist;
            }
            return resultOut;
        }
        return this.func_185503_a(pos, start, end, field_185505_j);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_185485_f(IBlockState state) {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntity tile = source.func_175625_s(pos);
        if (tile instanceof TileEntityStacks) {
            int count = 0;
            for (int i = 63; i > 0; --i) {
                if (((TileEntityStacks)tile).stacks[i] == null) continue;
                count = i;
                break;
            }
            float height = (float)((count + 7) / 8) * 0.125f;
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)height, 1.0);
        }
        return field_185505_j;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, @Nullable TileEntity te, int fortune, boolean silkTouch) {
        if (te instanceof TileEntityStacks) {
            TObjectIntHashMap materials = new TObjectIntHashMap();
            for (ItemStack stack : ((TileEntityStacks)te).stacks) {
                if (stack == null) continue;
                materials.adjustOrPutValue((Object)ItemMaterialRegistry.INSTANCE.getOrCreateMaterial(stack), 1, 1);
            }
            for (ItemMaterial material : materials.keySet()) {
                ItemStack stack = material.getStack();
                if (stack.func_190926_b()) continue;
                int count = materials.get((Object)material);
                for (int i = 0; i < count; i += stack.func_77976_d()) {
                    stack = stack.func_77946_l();
                    stack.func_190920_e(Math.min(count - i, stack.func_77976_d()));
                    drops.add((Object)stack);
                }
            }
        }
    }

    public boolean removedByPlayer(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(worldIn, pos, state, player);
        if (player.func_184812_l_()) {
            NonNullList drops = NonNullList.func_191196_a();
            this.getDrops((NonNullList<ItemStack>)drops, (IBlockAccess)worldIn, pos, state, worldIn.func_175625_s(pos), 0, false);
            for (ItemStack s : drops) {
                BlockStacks.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)s);
            }
            worldIn.func_175698_g(pos);
            return true;
        }
        return !this.cooldownMap.containsKey(player) || this.cooldownMap.get(player) < worldIn.func_82737_E();
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (te instanceof TileEntityStacks) {
            if (this.cooldownMap.containsKey(player) && this.cooldownMap.get(player) >= worldIn.func_82737_E()) {
                return;
            }
            if (player.func_70093_af()) {
                NonNullList drops = NonNullList.func_191196_a();
                this.getDrops((NonNullList<ItemStack>)drops, (IBlockAccess)worldIn, pos, state, te, 0, false);
                for (ItemStack s : drops) {
                    BlockStacks.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)s);
                }
                worldIn.func_175698_g(pos);
            } else {
                this.cooldownMap.put(player, worldIn.func_82737_E() + 1L);
                RayTraceResult result = this.func_180636_a(state, worldIn, pos, RayTraceUtils.getStart((EntityLivingBase)player), RayTraceUtils.getEnd((EntityLivingBase)player));
                Vec3d hitPos = result != null ? result.field_72307_f : null;
                ItemStack stackRemoved = ((TileEntityStacks)te).removeStack(false, hitPos);
                if (!stackRemoved.func_190926_b()) {
                    Vec3d loc;
                    if (stackRemoved.func_190916_E() > 1) {
                        stackRemoved = stackRemoved.func_77946_l();
                        stackRemoved.func_190920_e(1);
                    }
                    Vec3d vec3d = loc = hitPos != null ? hitPos : new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.95, (double)pos.func_177952_p() + 0.5);
                    if (CharsetImmersionStacks.insertToPlayerInventory) {
                        ItemUtils.giveOrSpawnItemEntity((EntityPlayer)player, (World)worldIn, (Vec3d)loc, (ItemStack)stackRemoved, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (boolean)true);
                    } else {
                        ItemUtils.spawnItemEntity((World)worldIn, (Vec3d)loc, (ItemStack)stackRemoved, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    }
                }
                if (((TileEntityStacks)te).isEmpty()) {
                    worldIn.func_175698_g(pos);
                }
            }
        }
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityStacks) {
            return ((IExtendedBlockState)state).withProperty(PROPERTY_TILE, (Object)((TileEntityStacks)tile));
        }
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{PROPERTY_TILE});
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityStacks();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        return true;
    }
}

