/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.immersion.stacks;

import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.oredict.OreDictionary;
import pl.asie.charset.lib.CharsetIMC;
import pl.asie.charset.lib.material.ItemMaterial;
import pl.asie.charset.lib.material.ItemMaterialRegistry;
import pl.asie.charset.lib.utils.ThreeState;

public class StackShapes {
    private static final Vec3d[] INGOT_POSITIONS_X;
    private static final Vec3d[] INGOT_POSITIONS_Z;
    protected static final Vec3d[][] INGOT_POSITIONS;
    protected static final Vec3d[] STACK_POSITIONS;

    public static FlatRenderMode getRenderMode(ItemStack stack) {
        int[] ids;
        ItemMaterial material = ItemMaterialRegistry.INSTANCE.getMaterialIfPresent(stack);
        if (material != null && material.getTypes().contains("stick")) {
            return FlatRenderMode.ROTATE;
        }
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            String name = OreDictionary.getOreName((int)id);
            if (!name.startsWith("gear")) continue;
            return FlatRenderMode.OFFSET;
        }
        return FlatRenderMode.OFFSET;
    }

    public static boolean isFlatPlaced(ItemStack stack) {
        int[] ids;
        ThreeState state = CharsetIMC.INSTANCE.allows("immersionStacksFlat", stack.func_77973_b().getRegistryName());
        if (state == ThreeState.YES) {
            return true;
        }
        if (state == ThreeState.NO) {
            return false;
        }
        boolean isFlat = false;
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            String name = OreDictionary.getOreName((int)id);
            if (name.startsWith("gear") || name.startsWith("plate") || name.startsWith("coin")) {
                isFlat = true;
                continue;
            }
            if (!name.startsWith("ingot")) continue;
            return false;
        }
        return isFlat;
    }

    public static boolean isIngot(ItemStack stack) {
        ItemMaterial material = ItemMaterialRegistry.INSTANCE.getMaterialIfPresent(stack);
        return material != null && material.getTypes().contains("ingot");
    }

    public static AxisAlignedBB getIngotBox(int i, ItemStack stack) {
        if (stack != null && StackShapes.isIngot(stack)) {
            return new AxisAlignedBB(StackShapes.INGOT_POSITIONS[i][0].field_72450_a / 16.0, StackShapes.INGOT_POSITIONS[i][0].field_72448_b / 16.0, StackShapes.INGOT_POSITIONS[i][0].field_72449_c / 16.0, StackShapes.INGOT_POSITIONS[i][2].field_72450_a / 16.0, StackShapes.INGOT_POSITIONS[i][6].field_72448_b / 16.0, StackShapes.INGOT_POSITIONS[i][2].field_72449_c / 16.0);
        }
        return new AxisAlignedBB(StackShapes.STACK_POSITIONS[i].field_72450_a / 16.0, StackShapes.STACK_POSITIONS[i].field_72448_b / 16.0, StackShapes.STACK_POSITIONS[i].field_72449_c / 16.0, (StackShapes.STACK_POSITIONS[i].field_72450_a + 8.0) / 16.0, (StackShapes.STACK_POSITIONS[i].field_72448_b + 1.0) / 16.0, (StackShapes.STACK_POSITIONS[i].field_72449_c + 8.0) / 16.0);
    }

    static {
        int i;
        double TOTAL_WIDTH = 4.0;
        double TOTAL_HEIGHT = 8.0;
        double Y_SIZE = 2.0;
        double TRAPEZOID_WIDTH_BOTTOM = 3.5;
        double TRAPEZOID_WIDTH_TOP = 3.0;
        double TRAPEZOID_HEIGHT_BOTTOM = 8.0;
        double TRAPEZOID_HEIGHT_TOP = 7.0;
        double TRAPEZOID_X_NEG_BOT = (TOTAL_WIDTH - TRAPEZOID_WIDTH_BOTTOM) / 2.0;
        double TRAPEZOID_Y_NEG_BOT = (TOTAL_HEIGHT - TRAPEZOID_HEIGHT_BOTTOM) / 2.0;
        double TRAPEZOID_X_NEG_TOP = (TOTAL_WIDTH - TRAPEZOID_WIDTH_TOP) / 2.0;
        double TRAPEZOID_Y_NEG_TOP = (TOTAL_HEIGHT - TRAPEZOID_HEIGHT_TOP) / 2.0;
        double TRAPEZOID_X_POS_BOT = TRAPEZOID_X_NEG_BOT + TRAPEZOID_WIDTH_BOTTOM;
        double TRAPEZOID_Y_POS_BOT = TRAPEZOID_Y_NEG_BOT + TRAPEZOID_HEIGHT_BOTTOM;
        double TRAPEZOID_X_POS_TOP = TRAPEZOID_X_NEG_TOP + TRAPEZOID_WIDTH_TOP;
        double TRAPEZOID_Y_POS_TOP = TRAPEZOID_Y_NEG_TOP + TRAPEZOID_HEIGHT_TOP;
        INGOT_POSITIONS_X = new Vec3d[]{new Vec3d(TRAPEZOID_X_NEG_BOT, 0.0, TRAPEZOID_Y_NEG_BOT), new Vec3d(TRAPEZOID_X_POS_BOT, 0.0, TRAPEZOID_Y_NEG_BOT), new Vec3d(TRAPEZOID_X_POS_BOT, 0.0, TRAPEZOID_Y_POS_BOT), new Vec3d(TRAPEZOID_X_NEG_BOT, 0.0, TRAPEZOID_Y_POS_BOT), new Vec3d(TRAPEZOID_X_NEG_TOP, Y_SIZE, TRAPEZOID_Y_NEG_TOP), new Vec3d(TRAPEZOID_X_POS_TOP, Y_SIZE, TRAPEZOID_Y_NEG_TOP), new Vec3d(TRAPEZOID_X_POS_TOP, Y_SIZE, TRAPEZOID_Y_POS_TOP), new Vec3d(TRAPEZOID_X_NEG_TOP, Y_SIZE, TRAPEZOID_Y_POS_TOP)};
        INGOT_POSITIONS_Z = new Vec3d[8];
        for (i = 0; i < 8; ++i) {
            StackShapes.INGOT_POSITIONS_Z[i] = new Vec3d(StackShapes.INGOT_POSITIONS_X[i].field_72449_c, StackShapes.INGOT_POSITIONS_X[i].field_72448_b, StackShapes.INGOT_POSITIONS_X[i].field_72450_a);
        }
        INGOT_POSITIONS = new Vec3d[64][];
        for (i = 0; i < 64; ++i) {
            int x;
            int z;
            Vec3d[] base;
            int y = i >> 2 & 0xFFFFFFFE;
            int target_i = i;
            if ((y & 2) == 2) {
                if ((i & 7) >= 2 && (i & 7) <= 5) {
                    target_i = i & 1 | 6 - (i & 6) | i & 0xFFFFFFF8;
                }
                base = INGOT_POSITIONS_Z;
                z = (i & 1 | i >> 1 & 2) * 4;
                x = (i & 2) * 4;
            } else {
                base = INGOT_POSITIONS_X;
                x = (i & 1 | i >> 1 & 2) * 4;
                z = (i & 2) * 4;
            }
            StackShapes.INGOT_POSITIONS[target_i] = new Vec3d[8];
            for (int j = 0; j < 8; ++j) {
                StackShapes.INGOT_POSITIONS[target_i][j] = base[j].func_72441_c((double)x, (double)y, (double)z);
            }
        }
        STACK_POSITIONS = new Vec3d[64];
        for (i = 0; i < 64; ++i) {
            int y = (i & 1) + (i >> 2 & 0xFFFFFFFE);
            int x = (i & 4) * 2;
            int z = (i & 2) * 4;
            StackShapes.STACK_POSITIONS[i] = new Vec3d((double)x, (double)y, (double)z);
        }
    }

    public static enum FlatRenderMode {
        OFFSET,
        ROTATE,
        OFFSET_ROTATE;

    }
}

