/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core;

import eu.ha3.matmos.core.Component;
import eu.ha3.matmos.core.Dependable;
import eu.ha3.matmos.core.Evaluated;
import eu.ha3.matmos.core.InformationContainer;
import eu.ha3.matmos.core.sheet.SheetCommander;
import eu.ha3.matmos.core.sheet.SheetIndex;
import eu.ha3.matmos.util.math.Numbers;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class Dynamic
extends Component
implements Evaluated,
InformationContainer<Long>,
Dependable {
    public static final String DEDICATED_SHEET = "_DYNAMIC";
    private long value;
    private final List<SheetIndex> indexes;
    private final SheetCommander<String> sheetCommander;
    private Collection<String> dependencies;

    public Dynamic(String name, SheetCommander<String> sheetCommander, List<SheetIndex> indexes) {
        super(name);
        this.sheetCommander = sheetCommander;
        this.indexes = indexes;
        this.dependencies = new HashSet<String>();
        for (SheetIndex index : indexes) {
            this.dependencies.add(index.getSheet());
        }
    }

    @Override
    public void evaluate() {
        long previous = this.value;
        this.value = 0L;
        for (SheetIndex sheetIndex : this.indexes) {
            Long value;
            if (!this.sheetCommander.exists(sheetIndex) || (value = Numbers.toLong(this.sheetCommander.get(sheetIndex))) == null) continue;
            this.value += value.longValue();
        }
        if (previous != this.value) {
            this.incrementVersion();
        }
    }

    @Override
    public Long getInformation() {
        return this.value;
    }

    @Override
    public Collection<String> getDependencies() {
        return this.dependencies;
    }

    public List<SheetIndex> getIndexes() {
        return Collections.unmodifiableList(this.indexes);
    }
}

