/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core;

import java.util.HashMap;
import java.util.Map;

public enum Operator {
    ALWAYS_FALSE("ALWAYS_FALSE", "><"){

        @Override
        public boolean test(Object one, Object two) {
            return false;
        }
    }
    ,
    ALWAYS_TRUE("ALWAYS_TRUE", "<>"){

        @Override
        public boolean test(Object one, Object two) {
            return true;
        }
    }
    ,
    EQUAL("EQUAL", "=="){

        @Override
        public boolean test(Object one, Object two) {
            return one == null && two == null || one.equals(two);
        }
    }
    ,
    NOT_EQUAL("NOT_EQUAL", "!="){

        @Override
        public boolean test(Object one, Object two) {
            return !EQUAL.test(one, two);
        }
    }
    ,
    GREATER("GREATER", ">"){

        @Override
        protected boolean testNumber(long one, long two) {
            return one > two;
        }
    }
    ,
    LESSER("LESSER", "<"){

        @Override
        protected boolean testNumber(long one, long two) {
            return one < two;
        }
    }
    ,
    GREATER_OR_EQUAL("GREATER_OR_EQUAL", ">="){

        @Override
        protected boolean testNumber(long one, long two) {
            return one >= two;
        }
    }
    ,
    LESSER_OR_EQUAL("LESSER_OR_EQUAL", "<="){

        @Override
        protected boolean testNumber(long one, long two) {
            return one <= two;
        }
    }
    ,
    IN_LIST("IN_LIST", "in"){

        @Override
        public boolean test(Object one, Object two) {
            return false;
        }
    }
    ,
    NOT_IN_LIST("NOT_IN_LIST", "!in"){

        @Override
        public boolean test(Object one, Object two) {
            return false;
        }
    };

    private static final Map<String, Operator> fromSerializedForm;
    private static final Map<String, Operator> fromSymbol;
    private final String symbol;
    private final String serializedForm;

    private Operator(String serializedForm, String symbol) {
        this.serializedForm = serializedForm;
        this.symbol = symbol;
    }

    public String toString() {
        return this.getSerializedForm();
    }

    public String getSerializedForm() {
        return this.serializedForm;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public static Operator fromSerializedForm(String serializedForm) {
        if (serializedForm == null || !fromSerializedForm.containsKey(serializedForm)) {
            return ALWAYS_FALSE;
        }
        return fromSerializedForm.get(serializedForm);
    }

    public static Operator fromSymbol(String symbol) {
        if (symbol == null || !fromSymbol.containsKey(symbol)) {
            return ALWAYS_FALSE;
        }
        return fromSymbol.get(symbol);
    }

    public boolean test(Object one, Object two) {
        if (one instanceof Number && two instanceof Number) {
            return this.testNumber(((Number)one).longValue(), ((Number)two).longValue());
        }
        return false;
    }

    protected boolean testNumber(long one, long two) {
        return false;
    }

    static {
        fromSerializedForm = new HashMap<String, Operator>();
        fromSymbol = new HashMap<String, Operator>();
        for (Operator op : Operator.values()) {
            fromSerializedForm.put(op.getSerializedForm(), op);
            fromSymbol.put(op.getSymbol(), op);
        }
    }
}

