/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core;

import eu.ha3.matmos.core.SoundRelay;
import eu.ha3.matmos.core.sound.StreamingSound;

public class StreamHandle<T extends StreamingSound> {
    private String path;
    private int token;
    private float largestVolumeCommandThisTick = -1.0f;
    private float fadeOfLargestVolumeCommandThisTick = -1.0f;
    private boolean commandedToBePlaying;
    private T sound;
    private SoundRelay relay;

    public StreamHandle(T sound, SoundRelay relay) {
        this.sound = sound;
        this.relay = relay;
    }

    public static <S extends StreamingSound> StreamHandle<S> of(S sound, SoundRelay relay) {
        return new StreamHandle<S>(sound, relay);
    }

    public T getSound() {
        return this.sound;
    }

    public void setSound(T sound) {
        this.sound = sound;
    }

    public boolean isCommandedToBePlaying() {
        return this.commandedToBePlaying;
    }

    public void setVolume(float volume, float fade) {
        if (volume > this.largestVolumeCommandThisTick) {
            this.largestVolumeCommandThisTick = volume;
            this.fadeOfLargestVolumeCommandThisTick = fade;
        }
    }

    public float getLargestVolumeCommandThisTick() {
        return this.largestVolumeCommandThisTick;
    }

    public float getFadeOfLargestVolumeCommandThisTick() {
        return this.fadeOfLargestVolumeCommandThisTick;
    }

    public void resetLargestVolumeCommandThisTick() {
        this.largestVolumeCommandThisTick = -1.0f;
    }

    public void setCommandedToBePlaying(boolean commandedToBePlaying) {
        this.commandedToBePlaying = commandedToBePlaying;
    }
}

